/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CopyOfEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public CopyOfEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doWork(Object ... values) throws IOException {
        if (Arrays.stream(values).anyMatch(item -> null == item)) {
            return null;
        }
        if (values.length < 1) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        List<Object> sourceValues = values[0] instanceof List ? (List<Object>)values[0] : Arrays.asList(values[0]);
        Integer length = sourceValues.size();
        if (values.length < 2) return sourceValues.subList(0, Math.min(length, sourceValues.size()));
        if (!(values[1] instanceof Number)) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - if second parameter is provided then it must be a valid number but found %s instead", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
        length = ((Number)values[1]).intValue();
        return sourceValues.subList(0, Math.min(length, sourceValues.size()));
    }
}

