/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

class EditLogBackupInputStream
extends EditLogInputStream {
    final String address;
    private final ByteBufferInputStream inner;
    private DataInputStream in;
    private FSEditLogOp.Reader reader = null;
    private FSEditLogLoader.PositionTrackingInputStream tracker = null;
    private int version = 0;

    EditLogBackupInputStream(String name) throws IOException {
        this.address = name;
        this.inner = new ByteBufferInputStream();
        this.in = null;
        this.reader = null;
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    protected FSEditLogOp nextOp() throws IOException {
        Preconditions.checkState((this.reader != null ? 1 : 0) != 0, (Object)"Must call setBytes() before readOp()");
        return this.reader.readOp(false);
    }

    @Override
    protected FSEditLogOp nextValidOp() {
        try {
            return this.reader.readOp(true);
        }
        catch (IOException e) {
            throw new RuntimeException("got unexpected IOException " + e, e);
        }
    }

    @Override
    public int getVersion(boolean verifyVersion) throws IOException {
        return this.version;
    }

    @Override
    public long getPosition() {
        return this.tracker.getPos();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long length() throws IOException {
        return this.inner.length();
    }

    void setBytes(byte[] newBytes, int version) throws IOException {
        this.inner.setData(newBytes);
        this.tracker = new FSEditLogLoader.PositionTrackingInputStream(this.inner);
        this.in = new DataInputStream(this.tracker);
        this.version = version;
        this.reader = FSEditLogOp.Reader.create(this.in, this.tracker, version);
    }

    void clear() throws IOException {
        this.setBytes(null, 0);
        this.reader = null;
        this.version = 0;
    }

    @Override
    public long getFirstTxId() {
        return -12345L;
    }

    @Override
    public long getLastTxId() {
        return -12345L;
    }

    @Override
    public boolean isInProgress() {
        return true;
    }

    @Override
    public void setMaxOpSize(int maxOpSize) {
        this.reader.setMaxOpSize(maxOpSize);
    }

    @Override
    public boolean isLocalLog() {
        return true;
    }

    private static class ByteBufferInputStream
    extends ByteArrayInputStream {
        ByteBufferInputStream() {
            super(new byte[0]);
        }

        void setData(byte[] newBytes) {
            this.buf = newBytes;
            this.count = newBytes == null ? 0 : newBytes.length;
            this.mark = 0;
            this.reset();
        }

        int length() {
            return this.count;
        }
    }
}

