/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.RoleAssignments;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class RoleAssignmentsImpl
extends CreatableResourcesImpl<RoleAssignment, RoleAssignmentImpl, RoleAssignmentInner>
implements RoleAssignments,
HasInner<RoleAssignmentsInner> {
    private final GraphRbacManager manager;

    RoleAssignmentsImpl(GraphRbacManager manager) {
        this.manager = manager;
    }

    protected RoleAssignmentImpl wrapModel(RoleAssignmentInner roleAssignmentInner) {
        if (roleAssignmentInner == null) {
            return null;
        }
        return new RoleAssignmentImpl(roleAssignmentInner.name(), roleAssignmentInner, this.manager());
    }

    public RoleAssignmentImpl getById(String objectId) {
        return (RoleAssignmentImpl)this.getByIdAsync(objectId).toBlocking().single();
    }

    public Observable<RoleAssignment> getByIdAsync(String id) {
        return this.manager().roleInner().roleAssignments().getByIdAsync(id).map((Func1)new Func1<RoleAssignmentInner, RoleAssignment>(){

            public RoleAssignment call(RoleAssignmentInner roleAssignmentInner) {
                if (roleAssignmentInner == null) {
                    return null;
                }
                return new RoleAssignmentImpl(roleAssignmentInner.name(), roleAssignmentInner, RoleAssignmentsImpl.this.manager());
            }
        });
    }

    public ServiceFuture<RoleAssignment> getByIdAsync(String id, ServiceCallback<RoleAssignment> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public RoleAssignmentImpl getByScope(String scope, String name) {
        return (RoleAssignmentImpl)this.getByScopeAsync(scope, name).toBlocking().single();
    }

    @Override
    public Observable<RoleAssignment> listByScopeAsync(String scope) {
        return this.wrapPageAsync(this.manager().roleInner().roleAssignments().listForScopeAsync(scope));
    }

    @Override
    public PagedList<RoleAssignment> listByScope(String scope) {
        return this.wrapList(this.manager().roleInner().roleAssignments().listForScope(scope));
    }

    @Override
    public ServiceFuture<RoleAssignment> getByScopeAsync(String scope, String name, ServiceCallback<RoleAssignment> callback) {
        return ServiceFuture.fromBody(this.getByScopeAsync(scope, name), callback);
    }

    @Override
    public Observable<RoleAssignment> getByScopeAsync(String scope, String name) {
        return this.manager().roleInner().roleAssignments().getAsync(scope, name).map((Func1)new Func1<RoleAssignmentInner, RoleAssignment>(){

            public RoleAssignment call(RoleAssignmentInner roleAssignmentInner) {
                if (roleAssignmentInner == null) {
                    return null;
                }
                return new RoleAssignmentImpl(roleAssignmentInner.name(), roleAssignmentInner, RoleAssignmentsImpl.this.manager());
            }
        });
    }

    public RoleAssignmentsInner inner() {
        return this.manager().roleInner().roleAssignments();
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    protected RoleAssignmentImpl wrapModel(String name) {
        return new RoleAssignmentImpl(name, new RoleAssignmentInner(), this.manager());
    }

    public Completable deleteByIdAsync(String id) {
        return this.manager().roleInner().roleAssignments().deleteByIdAsync(id).toCompletable();
    }

    public RoleAssignmentImpl define(String name) {
        return this.wrapModel(name);
    }
}

