/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.sql.AutomaticTuningOptionModeDesired;
import com.microsoft.azure.management.sql.AutomaticTuningServerMode;
import com.microsoft.azure.management.sql.AutomaticTuningServerOptions;
import com.microsoft.azure.management.sql.SqlServerAutomaticTuning;
import com.microsoft.azure.management.sql.implementation.ServerAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerAutomaticTuningImpl
extends RefreshableWrapperImpl<ServerAutomaticTuningInner, SqlServerAutomaticTuning>
implements SqlServerAutomaticTuning,
SqlServerAutomaticTuning.Update {
    protected String key;
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerAutomaticTuningImpl(SqlServerImpl server, ServerAutomaticTuningInner innerObject) {
        this(server.resourceGroupName(), server.name(), innerObject, (SqlServerManager)server.manager());
    }

    SqlServerAutomaticTuningImpl(String resourceGroupName, String sqlServerName, ServerAutomaticTuningInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.key = UUID.randomUUID().toString();
    }

    public String key() {
        return this.key;
    }

    @Override
    public AutomaticTuningServerMode desiredState() {
        return ((ServerAutomaticTuningInner)this.inner()).desiredState();
    }

    @Override
    public AutomaticTuningServerMode actualState() {
        return ((ServerAutomaticTuningInner)this.inner()).actualState();
    }

    @Override
    public Map<String, AutomaticTuningServerOptions> tuningOptions() {
        return Collections.unmodifiableMap(((ServerAutomaticTuningInner)this.inner()).options() != null ? ((ServerAutomaticTuningInner)this.inner()).options() : new HashMap());
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningMode(AutomaticTuningServerMode desiredState) {
        ((ServerAutomaticTuningInner)this.inner()).withDesiredState(desiredState);
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOption(String tuningOptionName, AutomaticTuningOptionModeDesired desiredState) {
        if (((ServerAutomaticTuningInner)this.inner()).options() == null) {
            ((ServerAutomaticTuningInner)this.inner()).withOptions(new HashMap<String, AutomaticTuningServerOptions>());
        }
        AutomaticTuningServerOptions item = ((ServerAutomaticTuningInner)this.inner()).options().get(tuningOptionName);
        ((ServerAutomaticTuningInner)this.inner()).options().put(tuningOptionName, item != null ? item.withDesiredState(desiredState) : new AutomaticTuningServerOptions().withDesiredState(desiredState));
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOptions(Map<String, AutomaticTuningOptionModeDesired> tuningOptions) {
        if (tuningOptions != null) {
            for (Map.Entry<String, AutomaticTuningOptionModeDesired> option : tuningOptions.entrySet()) {
                this.withAutomaticTuningOption(option.getKey(), option.getValue());
            }
        }
        return this;
    }

    protected Observable<ServerAutomaticTuningInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverAutomaticTunings().getAsync(this.resourceGroupName, this.sqlServerName);
    }

    public SqlServerAutomaticTuning apply() {
        return (SqlServerAutomaticTuning)this.applyAsync().toBlocking().last();
    }

    public Observable<SqlServerAutomaticTuning> applyAsync() {
        final SqlServerAutomaticTuningImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverAutomaticTunings().updateAsync(this.resourceGroupName, this.sqlServerName, (ServerAutomaticTuningInner)this.inner()).map((Func1)new Func1<ServerAutomaticTuningInner, SqlServerAutomaticTuning>(){

            public SqlServerAutomaticTuning call(ServerAutomaticTuningInner serverAutomaticTuningInner) {
                self.setInner(serverAutomaticTuningInner);
                return self;
            }
        });
    }

    public ServiceFuture<SqlServerAutomaticTuning> applyAsync(ServiceCallback<SqlServerAutomaticTuning> callback) {
        return ServiceFuture.fromBody(this.applyAsync(), callback);
    }

    public SqlServerAutomaticTuning.Update update() {
        return this;
    }
}

