/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.cdn.CdnProfile;
import com.microsoft.azure.management.cdn.CustomDomainValidationResult;
import com.microsoft.azure.management.cdn.EndpointResourceState;
import com.microsoft.azure.management.cdn.GeoFilter;
import com.microsoft.azure.management.cdn.GeoFilterActions;
import com.microsoft.azure.management.cdn.QueryStringCachingBehavior;
import com.microsoft.azure.management.cdn.ResourceUsage;
import com.microsoft.azure.management.cdn.implementation.EndpointInner;
import com.microsoft.azure.management.resources.fluentcore.arm.CountryIsoCode;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import rx.Completable;
import rx.Observable;

@Fluent
public interface CdnEndpoint
extends ExternalChildResource<CdnEndpoint, CdnProfile>,
HasInner<EndpointInner> {
    public String originHostHeader();

    public String originPath();

    public Set<String> contentTypesToCompress();

    public boolean isCompressionEnabled();

    public boolean isHttpAllowed();

    public boolean isHttpsAllowed();

    public QueryStringCachingBehavior queryStringCachingBehavior();

    public String optimizationType();

    public List<GeoFilter> geoFilters();

    public String hostName();

    public EndpointResourceState resourceState();

    public String provisioningState();

    public String originHostName();

    public int httpPort();

    public int httpsPort();

    public Set<String> customDomains();

    public void start();

    public Completable startAsync();

    public ServiceFuture<Void> startAsync(ServiceCallback<Void> var1);

    public void stop();

    public Completable stopAsync();

    public ServiceFuture<Void> stopAsync(ServiceCallback<Void> var1);

    public void purgeContent(Set<String> var1);

    public Completable purgeContentAsync(Set<String> var1);

    public ServiceFuture<Void> purgeContentAsync(Set<String> var1, ServiceCallback<Void> var2);

    public void loadContent(Set<String> var1);

    public Completable loadContentAsync(Set<String> var1);

    public ServiceFuture<Void> loadContentAsync(Set<String> var1, ServiceCallback<Void> var2);

    public CustomDomainValidationResult validateCustomDomain(String var1);

    public Observable<CustomDomainValidationResult> validateCustomDomainAsync(String var1);

    public ServiceFuture<CustomDomainValidationResult> validateCustomDomainAsync(String var1, ServiceCallback<CustomDomainValidationResult> var2);

    public PagedList<ResourceUsage> listResourceUsage();

    public static interface Update
    extends Settable<CdnProfile.Update> {
    }

    public static interface UpdatePremiumEndpoint
    extends Update {
        public UpdatePremiumEndpoint withOriginPath(String var1);

        public UpdatePremiumEndpoint withHostHeader(String var1);

        public UpdatePremiumEndpoint withHttpAllowed(boolean var1);

        public UpdatePremiumEndpoint withHttpsAllowed(boolean var1);

        public UpdatePremiumEndpoint withHttpPort(int var1);

        public UpdatePremiumEndpoint withHttpsPort(int var1);

        public UpdatePremiumEndpoint withCustomDomain(String var1);

        public UpdatePremiumEndpoint withoutCustomDomain(String var1);
    }

    public static interface UpdateStandardEndpoint
    extends Update {
        public UpdateStandardEndpoint withOriginPath(String var1);

        public UpdateStandardEndpoint withHostHeader(String var1);

        public UpdateStandardEndpoint withHttpAllowed(boolean var1);

        public UpdateStandardEndpoint withHttpsAllowed(boolean var1);

        public UpdateStandardEndpoint withHttpPort(int var1);

        public UpdateStandardEndpoint withHttpsPort(int var1);

        public UpdateStandardEndpoint withContentTypesToCompress(Set<String> var1);

        public UpdateStandardEndpoint withoutContentTypesToCompress();

        public UpdateStandardEndpoint withContentTypeToCompress(String var1);

        public UpdateStandardEndpoint withoutContentTypeToCompress(String var1);

        public UpdateStandardEndpoint withCompressionEnabled(boolean var1);

        public UpdateStandardEndpoint withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

        public UpdateStandardEndpoint withGeoFilters(Collection<GeoFilter> var1);

        public UpdateStandardEndpoint withoutGeoFilters();

        public UpdateStandardEndpoint withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

        public UpdateStandardEndpoint withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

        public UpdateStandardEndpoint withoutGeoFilter(String var1);

        public UpdateStandardEndpoint withCustomDomain(String var1);

        public UpdateStandardEndpoint withoutCustomDomain(String var1);
    }

    public static interface UpdateDefinitionStages {

        public static interface AttachablePremium<ParentT> {
            @Method
            public ParentT attach();
        }

        public static interface AttachableStandard<ParentT> {
            @Method
            public ParentT attach();
        }

        public static interface WithPremiumAttach<ParentT>
        extends AttachablePremium<ParentT> {
            public WithPremiumAttach<ParentT> withOriginPath(String var1);

            public WithPremiumAttach<ParentT> withHostHeader(String var1);

            public WithPremiumAttach<ParentT> withHttpAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpPort(int var1);

            public WithPremiumAttach<ParentT> withHttpsPort(int var1);

            public WithPremiumAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface WithStandardAttach<ParentT>
        extends AttachableStandard<ParentT> {
            public WithStandardAttach<ParentT> withOriginPath(String var1);

            public WithStandardAttach<ParentT> withHostHeader(String var1);

            public WithStandardAttach<ParentT> withHttpAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpPort(int var1);

            public WithStandardAttach<ParentT> withHttpsPort(int var1);

            public WithStandardAttach<ParentT> withContentTypesToCompress(Set<String> var1);

            public WithStandardAttach<ParentT> withContentTypeToCompress(String var1);

            public WithStandardAttach<ParentT> withCompressionEnabled(boolean var1);

            public WithStandardAttach<ParentT> withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

            public WithStandardAttach<ParentT> withGeoFilters(Collection<GeoFilter> var1);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

            public WithStandardAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface Blank {

            public static interface PremiumEndpoint<ParentT> {
                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1, String var2);

                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1);
            }

            public static interface StandardEndpoint<ParentT> {
                public WithStandardAttach<ParentT> withOrigin(String var1, String var2);

                public WithStandardAttach<ParentT> withOrigin(String var1);
            }
        }
    }

    public static interface DefinitionStages {

        public static interface AttachablePremium<ParentT> {
            @Method
            public ParentT attach();
        }

        public static interface AttachableStandard<ParentT> {
            @Method
            public ParentT attach();
        }

        public static interface WithPremiumAttach<ParentT>
        extends AttachablePremium<ParentT> {
            public WithPremiumAttach<ParentT> withOriginPath(String var1);

            public WithPremiumAttach<ParentT> withHostHeader(String var1);

            public WithPremiumAttach<ParentT> withHttpAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithPremiumAttach<ParentT> withHttpPort(int var1);

            public WithPremiumAttach<ParentT> withHttpsPort(int var1);

            public WithPremiumAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface WithStandardAttach<ParentT>
        extends AttachableStandard<ParentT> {
            public WithStandardAttach<ParentT> withOriginPath(String var1);

            public WithStandardAttach<ParentT> withHostHeader(String var1);

            public WithStandardAttach<ParentT> withHttpAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpsAllowed(boolean var1);

            public WithStandardAttach<ParentT> withHttpPort(int var1);

            public WithStandardAttach<ParentT> withHttpsPort(int var1);

            public WithStandardAttach<ParentT> withContentTypesToCompress(Set<String> var1);

            public WithStandardAttach<ParentT> withContentTypeToCompress(String var1);

            public WithStandardAttach<ParentT> withCompressionEnabled(boolean var1);

            public WithStandardAttach<ParentT> withQueryStringCachingBehavior(QueryStringCachingBehavior var1);

            public WithStandardAttach<ParentT> withGeoFilters(Collection<GeoFilter> var1);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, CountryIsoCode var3);

            public WithStandardAttach<ParentT> withGeoFilter(String var1, GeoFilterActions var2, Collection<CountryIsoCode> var3);

            public WithStandardAttach<ParentT> withCustomDomain(String var1);
        }

        public static interface Blank {

            public static interface PremiumEndpoint<ParentT> {
                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1, String var2);

                public WithPremiumAttach<ParentT> withPremiumOrigin(String var1);
            }

            public static interface StandardEndpoint<ParentT> {
                public WithStandardAttach<ParentT> withOrigin(String var1, String var2);

                public WithStandardAttach<ParentT> withOrigin(String var1);
            }
        }
    }
}

