/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.sedona.shaded.antlr.tree.ParseTree;
import org.apache.sedona.shaded.jiffle.parser.BaseWorker;
import org.apache.sedona.shaded.jiffle.parser.ConstantLookup;
import org.apache.sedona.shaded.jiffle.parser.JiffleParser;
import org.apache.sedona.shaded.jiffle.parser.OptionLookup;
import org.apache.sedona.shaded.jiffle.parser.UndefinedOptionException;

public class OptionsBlockWorker
extends BaseWorker {
    public final Map<String, String> options = new HashMap<String, String>();
    private boolean readBlock = false;

    public OptionsBlockWorker(ParseTree tree) {
        super(tree);
        this.walkTree();
    }

    @Override
    public void enterOptionsBlock(JiffleParser.OptionsBlockContext ctx) {
        if (this.readBlock) {
            this.messages.error(ctx.start, "Script has more than one options block");
        }
    }

    @Override
    public void exitOptionsBlock(JiffleParser.OptionsBlockContext ctx) {
        if (!this.readBlock) {
            for (JiffleParser.OptionContext oc : ctx.option()) {
                this.addOption(oc);
            }
            this.readBlock = true;
        }
    }

    private void addOption(JiffleParser.OptionContext oc) {
        String name = oc.ID().getText();
        String value = oc.optionValue().getText();
        try {
            if (OptionLookup.isValidValue(name, value)) {
                if ("null".equals(value)) {
                    value = "Double.NaN";
                } else if (ConstantLookup.isDefined(value)) {
                    double constantValue = ConstantLookup.getValue(value);
                    value = Double.isNaN(constantValue) ? "Double.NaN" : Double.toString(constantValue);
                }
                this.options.put(name, value);
            } else {
                this.messages.error(oc.getStart(), String.format("Invalid value (%s) for option %s", value, name));
            }
        }
        catch (UndefinedOptionException ex) {
            this.messages.error(oc.getStart(), "Unknown option " + name);
        }
    }
}

