/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.value;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;

public final class ListShardingConditionValue<T>
implements ShardingConditionValue {
    private final String columnName;
    private final String tableName;
    private final Collection<T> values;
    private final List<Integer> parameterMarkerIndexes;

    public ListShardingConditionValue(String columnName, String tableName, Collection<T> values) {
        this(columnName, tableName, values, Collections.emptyList());
    }

    public String toString() {
        String condition = 1 == this.values.size() ? " = " + new ArrayList<T>(this.values).get(0) : " in (" + Joiner.on((String)",").useForNull("").join(this.values) + ")";
        return this.tableName + "." + this.columnName + condition;
    }

    @Generated
    public ListShardingConditionValue(String columnName, String tableName, Collection<T> values, List<Integer> parameterMarkerIndexes) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.values = values;
        this.parameterMarkerIndexes = parameterMarkerIndexes;
    }

    @Override
    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Collection<T> getValues() {
        return this.values;
    }

    @Override
    @Generated
    public List<Integer> getParameterMarkerIndexes() {
        return this.parameterMarkerIndexes;
    }
}

