/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import com.google.common.base.Preconditions;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.checker.ActiveVersionChecker;

public final class StorageUnitChangedHandler {
    private final ContextManager contextManager;

    public void handleRegistered(String databaseName, String dataSourceUnitName, DataChangedEvent event) {
        ActiveVersionChecker.checkActiveVersion(this.contextManager, event);
        DataSourcePoolProperties dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDataSourceUnitService().load(databaseName, dataSourceUnitName);
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().registerStorageUnit(databaseName, Collections.singletonMap(dataSourceUnitName, dataSourcePoolProps));
    }

    public void handleAltered(String databaseName, String dataSourceUnitName, DataChangedEvent event) {
        ActiveVersionChecker.checkActiveVersion(this.contextManager, event);
        DataSourcePoolProperties dataSourcePoolProps = this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getDataSourceUnitService().load(databaseName, dataSourceUnitName);
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().alterStorageUnit(databaseName, Collections.singletonMap(dataSourceUnitName, dataSourcePoolProps));
    }

    public void handleUnregistered(String databaseName, String dataSourceUnitName) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(databaseName), (String)"No database '%s' exists.", (Object)databaseName);
        this.contextManager.getMetaDataContextManager().getStorageUnitManager().unregisterStorageUnit(databaseName, dataSourceUnitName);
    }

    @Generated
    public StorageUnitChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

