/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.exception.PostgreSQLProtocolException;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.PostgreSQLTextValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLBitValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLBoolValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLDateValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLDoubleValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLFloatValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLIntValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLJsonValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLLongValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLNumericValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLTextArrayValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLTimeValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLTimestampValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLUnspecifiedValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLVarcharArrayValueParser;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.text.impl.PostgreSQLVarcharValueParser;

public enum PostgreSQLColumnType implements BinaryColumnType
{
    UNSPECIFIED(0, new PostgreSQLUnspecifiedValueParser()),
    INT2(21, new PostgreSQLIntValueParser()),
    INT2_ARRAY(1005, new PostgreSQLVarcharValueParser()),
    INT4(23, new PostgreSQLIntValueParser()),
    INT4_ARRAY(1007, new PostgreSQLVarcharValueParser()),
    INT8(20, new PostgreSQLLongValueParser()),
    INT8_ARRAY(1016, new PostgreSQLVarcharValueParser()),
    TEXT(25, new PostgreSQLVarcharValueParser()),
    TEXT_ARRAY(1009, new PostgreSQLTextArrayValueParser()),
    NUMERIC(1700, new PostgreSQLNumericValueParser()),
    NUMERIC_ARRAY(1231, new PostgreSQLVarcharValueParser()),
    FLOAT4(700, new PostgreSQLFloatValueParser()),
    FLOAT4_ARRAY(1021, new PostgreSQLVarcharValueParser()),
    FLOAT8(701, new PostgreSQLDoubleValueParser()),
    FLOAT8_ARRAY(1022, new PostgreSQLVarcharValueParser()),
    BOOL(16, new PostgreSQLBoolValueParser()),
    BOOL_ARRAY(1000, new PostgreSQLVarcharValueParser()),
    DATE(1082, new PostgreSQLDateValueParser()),
    DATE_ARRAY(1182, new PostgreSQLVarcharValueParser()),
    TIME(1083, new PostgreSQLTimeValueParser()),
    TIME_ARRAY(1183, new PostgreSQLVarcharValueParser()),
    TIMETZ(1266, new PostgreSQLTimeValueParser()),
    TIMETZ_ARRAY(1270, new PostgreSQLVarcharValueParser()),
    TIMESTAMP(1114, new PostgreSQLTimestampValueParser()),
    TIMESTAMP_ARRAY(1115, new PostgreSQLVarcharValueParser()),
    TIMESTAMPTZ(1184, new PostgreSQLTimestampValueParser()),
    TIMESTAMPTZ_ARRAY(1185, new PostgreSQLVarcharValueParser()),
    BYTEA(17, new PostgreSQLVarcharValueParser()),
    BYTEA_ARRAY(1001, new PostgreSQLVarcharValueParser()),
    VARCHAR(1043, new PostgreSQLVarcharValueParser()),
    VARCHAR_ARRAY(1015, new PostgreSQLVarcharArrayValueParser()),
    OID(26, new PostgreSQLVarcharValueParser()),
    OID_ARRAY(1028, new PostgreSQLVarcharValueParser()),
    BPCHAR(1042, new PostgreSQLVarcharValueParser()),
    BPCHAR_ARRAY(1014, new PostgreSQLVarcharValueParser()),
    MONEY(790, new PostgreSQLVarcharValueParser()),
    MONEY_ARRAY(791, new PostgreSQLVarcharValueParser()),
    NAME(19, new PostgreSQLVarcharValueParser()),
    NAME_ARRAY(1003, new PostgreSQLVarcharValueParser()),
    BIT(1560, new PostgreSQLBitValueParser()),
    BIT_ARRAY(1561, new PostgreSQLVarcharValueParser()),
    VOID(2278, new PostgreSQLVarcharValueParser()),
    INTERVAL(1186, new PostgreSQLVarcharValueParser()),
    INTERVAL_ARRAY(1187, new PostgreSQLVarcharValueParser()),
    CHAR(18, new PostgreSQLVarcharValueParser()),
    CHAR_ARRAY(1002, new PostgreSQLVarcharValueParser()),
    VARBIT(1562, new PostgreSQLVarcharValueParser()),
    VARBIT_ARRAY(1563, new PostgreSQLVarcharValueParser()),
    UUID(2950, new PostgreSQLVarcharValueParser()),
    UUID_ARRAY(2951, new PostgreSQLVarcharValueParser()),
    XML(142, new PostgreSQLVarcharValueParser()),
    XML_ARRAY(143, new PostgreSQLVarcharValueParser()),
    POINT(600, new PostgreSQLVarcharValueParser()),
    POINT_ARRAY(1017, new PostgreSQLVarcharValueParser()),
    BOX(603, new PostgreSQLVarcharValueParser()),
    JSONB_ARRAY(3807, new PostgreSQLVarcharValueParser()),
    JSON(114, new PostgreSQLJsonValueParser()),
    JSON_ARRAY(199, new PostgreSQLVarcharValueParser()),
    REF_CURSOR(1790, new PostgreSQLVarcharValueParser()),
    REF_CURSOR_ARRAY(2201, new PostgreSQLVarcharValueParser());

    private static final Map<Integer, PostgreSQLColumnType> JDBC_TYPE_AND_COLUMN_TYPE_MAP;
    private final int value;
    private final PostgreSQLTextValueParser<?> textValueParser;

    public static PostgreSQLColumnType valueOfJDBCType(int jdbcType) {
        Preconditions.checkArgument((boolean)JDBC_TYPE_AND_COLUMN_TYPE_MAP.containsKey(jdbcType), (String)"Can not find JDBC type `%s` in PostgreSQL column type", (int)jdbcType);
        return JDBC_TYPE_AND_COLUMN_TYPE_MAP.get(jdbcType);
    }

    public static PostgreSQLColumnType valueOfJDBCType(int jdbcType, String columnTypeName) {
        if (PostgreSQLColumnType.isBit(jdbcType, columnTypeName)) {
            return BIT;
        }
        if (PostgreSQLColumnType.isBool(jdbcType, columnTypeName)) {
            return BOOL;
        }
        if (PostgreSQLColumnType.isUUID(jdbcType, columnTypeName)) {
            return UUID;
        }
        return PostgreSQLColumnType.valueOfJDBCType(jdbcType);
    }

    public static boolean isBit(int jdbcType, String columnTypeName) {
        return -7 == jdbcType && "bit".equalsIgnoreCase(columnTypeName);
    }

    public static boolean isBool(int jdbcType, String columnTypeName) {
        return -7 == jdbcType && "bool".equalsIgnoreCase(columnTypeName);
    }

    public static boolean isUUID(int jdbcType, String columnTypeName) {
        return 1111 == jdbcType && "uuid".equalsIgnoreCase(columnTypeName);
    }

    public static PostgreSQLColumnType valueOf(int value) {
        for (PostgreSQLColumnType each : PostgreSQLColumnType.values()) {
            if (value != each.value) continue;
            return each;
        }
        throw new PostgreSQLProtocolException("Can not find value `%s` in PostgreSQL column type.", value);
    }

    @Generated
    private PostgreSQLColumnType(int value, PostgreSQLTextValueParser<?> textValueParser) {
        this.value = value;
        this.textValueParser = textValueParser;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    @Generated
    public PostgreSQLTextValueParser<?> getTextValueParser() {
        return this.textValueParser;
    }

    static {
        JDBC_TYPE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, PostgreSQLColumnType>(PostgreSQLColumnType.values().length, 1.0f);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-6, INT2);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(5, INT2);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(4, INT4);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-5, INT8);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2, NUMERIC);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(3, NUMERIC);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(7, FLOAT4);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(8, FLOAT8);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(1, CHAR);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(12, VARCHAR);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-2, BYTEA);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-7, BIT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(91, DATE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(92, TIME);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(93, TIMESTAMP);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(1111, JSON);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2009, XML);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(16, BOOL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2002, VARCHAR);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2003, TEXT_ARRAY);
    }
}

