/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.distsql.handler.converter.MaskRuleStatementConverter;
import org.apache.shardingsphere.mask.distsql.segment.MaskRuleSegment;
import org.apache.shardingsphere.mask.distsql.statement.CreateMaskRuleStatement;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class CreateMaskRuleExecutor
implements DatabaseRuleCreateExecutor<CreateMaskRuleStatement, MaskRule, MaskRuleConfiguration> {
    private ShardingSphereDatabase database;
    private MaskRule rule;
    private boolean ifNotExists;

    public void checkBeforeUpdate(CreateMaskRuleStatement sqlStatement) {
        this.ifNotExists = sqlStatement.isIfNotExists();
        if (!this.ifNotExists) {
            this.checkDuplicatedRuleNames(sqlStatement);
        }
        this.checkAlgorithms(sqlStatement);
    }

    private void checkDuplicatedRuleNames(CreateMaskRuleStatement sqlStatement) {
        if (null != this.rule) {
            Collection currentRuleNames = this.rule.getConfiguration().getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toList());
            Collection duplicatedRuleNames = sqlStatement.getRules().stream().map(MaskRuleSegment::getTableName).filter(currentRuleNames::contains).collect(Collectors.toList());
            ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedRuleNames, () -> new DuplicateRuleException("mask", this.database.getName(), duplicatedRuleNames));
        }
    }

    private void checkAlgorithms(CreateMaskRuleStatement sqlStatement) {
        LinkedList columns = new LinkedList();
        sqlStatement.getRules().forEach(each -> columns.addAll(each.getColumns()));
        columns.forEach(each -> TypedSPILoader.checkService(MaskAlgorithm.class, (Object)each.getAlgorithm().getName(), (Properties)each.getAlgorithm().getProps()));
    }

    public MaskRuleConfiguration buildToBeCreatedRuleConfiguration(CreateMaskRuleStatement sqlStatement) {
        return MaskRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public Class<MaskRule> getRuleClass() {
        return MaskRule.class;
    }

    public Class<CreateMaskRuleStatement> getType() {
        return CreateMaskRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(MaskRule rule) {
        this.rule = rule;
    }

    @Generated
    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }
}

