/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.ddl;

import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.checker.sql.util.ShardingSupportedCheckUtils;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingCreateTableRouteContextChecker
implements ShardingRouteContextChecker {
    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        CreateTableStatementContext createTableStatementContext = (CreateTableStatementContext)queryContext.getSqlStatementContext();
        String primaryTable = createTableStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        if (ShardingSupportedCheckUtils.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, primaryTable)) {
            throw new ShardingDDLRouteException("CREATE", "TABLE", createTableStatementContext.getTablesContext().getTableNames());
        }
    }
}

