/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class ComputeNodePath {
    private static final String ROOT_NODE = "/nodes/compute_nodes";
    private static final String ONLINE_NODE = "online";
    private static final String SHOW_PROCESS_LIST_TRIGGER_NODE = "show_process_list_trigger";
    private static final String KILL_PROCESS_TRIGGER_NODE = "kill_process_trigger";
    private static final String STATUS_NODE = "status";
    private static final String WORKER_ID_NODE = "worker_id";
    private static final String LABELS_NODE = "labels";
    private static final String INSTANCE_ID_PATTERN = "([\\S]+)";

    public static String getRootPath() {
        return ROOT_NODE;
    }

    public static String getOnlineRootPath() {
        return String.join((CharSequence)"/", ComputeNodePath.getRootPath(), ONLINE_NODE);
    }

    public static String getOnlinePath(InstanceType instanceType) {
        return String.join((CharSequence)"/", ComputeNodePath.getOnlineRootPath(), instanceType.name().toLowerCase());
    }

    public static String getOnlinePath(String instanceId, InstanceType instanceType) {
        return String.join((CharSequence)"/", ComputeNodePath.getOnlinePath(instanceType), instanceId);
    }

    public static String getShowProcessListTriggerRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, SHOW_PROCESS_LIST_TRIGGER_NODE);
    }

    public static String getShowProcessListTriggerPath(String instanceId, String taskId) {
        return String.join((CharSequence)"/", ComputeNodePath.getShowProcessListTriggerRootPath(), String.join((CharSequence)":", instanceId, taskId));
    }

    public static String getKillProcessTriggerRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, KILL_PROCESS_TRIGGER_NODE);
    }

    public static String getKillProcessTriggerPath(String instanceId, String processId) {
        return String.join((CharSequence)"/", ComputeNodePath.getKillProcessTriggerRootPath(), String.join((CharSequence)":", instanceId, processId));
    }

    public static String getStatePath(String instanceId) {
        return String.join((CharSequence)"/", ROOT_NODE, STATUS_NODE, instanceId);
    }

    public static String getWorkerIdRootPath() {
        return String.join((CharSequence)"/", ROOT_NODE, WORKER_ID_NODE);
    }

    public static String getWorkerIdPath(String instanceId) {
        return String.join((CharSequence)"/", ComputeNodePath.getWorkerIdRootPath(), instanceId);
    }

    public static String getLabelsPath(String instanceId) {
        return String.join((CharSequence)"/", ROOT_NODE, LABELS_NODE, instanceId);
    }

    public static Optional<String> findInstanceId(String computeNodePath) {
        Pattern pattern = Pattern.compile(ComputeNodePath.getRootPath() + "(/status|/worker_id|/labels)/" + INSTANCE_ID_PATTERN + "$", 2);
        Matcher matcher = pattern.matcher(computeNodePath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    @Generated
    private ComputeNodePath() {
    }
}

