/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.prepare;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCJobItemContext;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCChannelProgressPair;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.CDCImporter;
import org.apache.shardingsphere.data.pipeline.cdc.core.task.CDCIncrementalTask;
import org.apache.shardingsphere.data.pipeline.cdc.core.task.CDCInventoryTask;
import org.apache.shardingsphere.data.pipeline.core.channel.IncrementalChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.channel.InventoryChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.CreateIncrementalDumperParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.InventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.type.PlaceholderInventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.type.UniqueKeyInventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter.InventoryDumperContextSplitter;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTaskUtils;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJobPreparer.class);
    private final PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager;

    public void initTasks(Collection<CDCJobItemContext> jobItemContexts) {
        AtomicBoolean inventoryImporterUsed = new AtomicBoolean();
        CopyOnWriteArrayList<CDCChannelProgressPair> inventoryChannelProgressPairs = new CopyOnWriteArrayList<CDCChannelProgressPair>();
        AtomicBoolean incrementalImporterUsed = new AtomicBoolean();
        CopyOnWriteArrayList<CDCChannelProgressPair> incrementalChannelProgressPairs = new CopyOnWriteArrayList<CDCChannelProgressPair>();
        for (CDCJobItemContext each : jobItemContexts) {
            this.initTasks(each, inventoryImporterUsed, inventoryChannelProgressPairs, incrementalImporterUsed, incrementalChannelProgressPairs);
        }
    }

    private void initTasks(CDCJobItemContext jobItemContext, AtomicBoolean inventoryImporterUsed, List<CDCChannelProgressPair> inventoryChannelProgressPairs, AtomicBoolean incrementalImporterUsed, List<CDCChannelProgressPair> incrementalChannelProgressPairs) {
        Optional jobItemProgress = this.jobItemManager.getProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem());
        if (!jobItemProgress.isPresent()) {
            this.jobItemManager.persistProgress((PipelineJobItemContext)jobItemContext);
        }
        if (jobItemContext.isStopping()) {
            PipelineJobRegistry.stop((String)jobItemContext.getJobId());
            return;
        }
        this.initIncrementalPosition(jobItemContext);
        if (jobItemContext.getJobConfig().isFull()) {
            this.initInventoryTasks(jobItemContext, inventoryImporterUsed, inventoryChannelProgressPairs);
        }
        this.initIncrementalTask(jobItemContext, incrementalImporterUsed, incrementalChannelProgressPairs);
    }

    private void initIncrementalPosition(CDCJobItemContext jobItemContext) {
        CDCTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        JobItemIncrementalTasksProgress initIncremental = null == jobItemContext.getInitProgress() ? null : jobItemContext.getInitProgress().getIncremental();
        try {
            DatabaseType databaseType = taskConfig.getDumperContext().getCommonContext().getDataSourceConfig().getDatabaseType();
            IngestPosition position = new IncrementalTaskPositionManager(databaseType).getPosition(initIncremental, taskConfig.getDumperContext(), jobItemContext.getDataSourceManager());
            taskConfig.getDumperContext().getCommonContext().setPosition(position);
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobItemContext.getJobId(), ex);
        }
    }

    private void initInventoryTasks(CDCJobItemContext jobItemContext, AtomicBoolean importerUsed, List<CDCChannelProgressPair> channelProgressPairs) {
        long startTimeMillis = System.currentTimeMillis();
        CDCTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        ImporterConfiguration importerConfig = taskConfig.getImporterConfig();
        TransmissionProcessContext processContext = jobItemContext.getJobProcessContext();
        InventoryDumperContextSplitter dumperContextSplitter = new InventoryDumperContextSplitter(jobItemContext.getSourceDataSource(), new InventoryDumperContext(taskConfig.getDumperContext().getCommonContext()));
        for (InventoryDumperContext each : dumperContextSplitter.split((TransmissionJobItemContext)jobItemContext)) {
            AtomicReference<IngestPosition> position = new AtomicReference<IngestPosition>(each.getCommonContext().getPosition());
            PipelineChannel channel = InventoryChannelCreator.create((AlgorithmConfiguration)processContext.getProcessConfiguration().getStreamChannel(), (int)importerConfig.getBatchSize(), position);
            if (!(position.get() instanceof IngestFinishedPosition)) {
                channelProgressPairs.add(new CDCChannelProgressPair(channel, (PipelineJobProgressListener)jobItemContext));
            }
            UniqueKeyInventoryDataRecordPositionCreator positionCreator = each.hasUniqueKey() ? new UniqueKeyInventoryDataRecordPositionCreator() : new PlaceholderInventoryDataRecordPositionCreator();
            InventoryDumper dumper = new InventoryDumper(each, channel, (DataSource)jobItemContext.getSourceDataSource(), jobItemContext.getSourceMetaDataLoader(), (InventoryDataRecordPositionCreator)positionCreator);
            CDCImporter importer = importerUsed.get() ? null : new CDCImporter(channelProgressPairs, importerConfig.getBatchSize(), 100L, jobItemContext.getSink(), false, importerConfig.getRateLimitAlgorithm());
            jobItemContext.getInventoryTasks().add(new CDCInventoryTask(PipelineTaskUtils.generateInventoryTaskId((InventoryDumperContext)each), processContext.getInventoryDumperExecuteEngine(), processContext.getInventoryImporterExecuteEngine(), (Dumper)dumper, importer, position));
            if (position.get() instanceof IngestFinishedPosition) continue;
            importerUsed.set(true);
        }
        log.info("Init inventory tasks cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void initIncrementalTask(CDCJobItemContext jobItemContext, AtomicBoolean importerUsed, List<CDCChannelProgressPair> channelProgressPairs) {
        CDCTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        IncrementalDumperContext dumperContext = taskConfig.getDumperContext();
        IncrementalTaskProgress taskProgress = PipelineTaskUtils.createIncrementalTaskProgress((IngestPosition)dumperContext.getCommonContext().getPosition(), (TransmissionJobItemProgress)jobItemContext.getInitProgress());
        PipelineChannel channel = IncrementalChannelCreator.create((AlgorithmConfiguration)jobItemContext.getJobProcessContext().getProcessConfiguration().getStreamChannel(), (IncrementalTaskProgress)taskProgress);
        channelProgressPairs.add(new CDCChannelProgressPair(channel, (PipelineJobProgressListener)jobItemContext));
        CreateIncrementalDumperParameter param = new CreateIncrementalDumperParameter(dumperContext, dumperContext.getCommonContext().getPosition(), channel, jobItemContext.getSourceMetaDataLoader(), jobItemContext.getDataSourceManager());
        IncrementalDumper dumper = IncrementalDumperCreator.create((CreateIncrementalDumperParameter)param);
        boolean needSorting = jobItemContext.getJobConfig().isDecodeWithTX();
        CDCImporter importer = importerUsed.get() ? null : new CDCImporter(channelProgressPairs, 1, 100L, jobItemContext.getSink(), needSorting, taskConfig.getImporterConfig().getRateLimitAlgorithm());
        CDCIncrementalTask incrementalTask = new CDCIncrementalTask(dumperContext.getCommonContext().getDataSourceName(), jobItemContext.getJobProcessContext().getIncrementalExecuteEngine(), (Dumper)dumper, importer, taskProgress);
        jobItemContext.getIncrementalTasks().add(incrementalTask);
        importerUsed.set(true);
    }

    @Generated
    public CDCJobPreparer(PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        this.jobItemManager = jobItemManager;
    }
}

