/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.Objects;
import org.apache.shenyu.common.dto.BaseData;

public class PluginData
extends BaseData {
    private String config;
    private String role;
    private String pluginJar;

    public PluginData() {
    }

    public PluginData(String id, String name, String config, String role, Boolean enabled, String pluginJar) {
        this.setId(id);
        this.setName(name);
        this.config = config;
        this.role = role;
        this.setEnabled(enabled);
        this.pluginJar = pluginJar;
    }

    public PluginData(String id, String name, String config, String role, Boolean enabled, Integer sort, String pluginJar) {
        this.setId(id);
        this.setName(name);
        this.config = config;
        this.role = role;
        this.setEnabled(enabled);
        this.setSort(sort);
        this.pluginJar = pluginJar;
    }

    public PluginData(String id, String name, String config, String role, Boolean enabled, Integer sort, String pluginJar, String namespaceId) {
        this.setId(id);
        this.setName(name);
        this.config = config;
        this.role = role;
        this.setEnabled(enabled);
        this.setSort(sort);
        this.pluginJar = pluginJar;
        this.setNamespaceId(namespaceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPluginJar() {
        return this.pluginJar;
    }

    public void setPluginJar(String pluginJar) {
        this.pluginJar = pluginJar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        PluginData that = (PluginData)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.config, that.config) && Objects.equals(this.role, that.role) && Objects.equals(this.getEnabled(), that.getEnabled()) && Objects.equals(this.getSort(), that.getSort()) && Objects.equals(this.pluginJar, that.pluginJar) && Objects.equals(this.getNamespaceId(), that.getNamespaceId());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName(), this.config, this.role, this.getEnabled(), this.getSort(), this.pluginJar, this.getNamespaceId());
    }

    public static final class Builder {
        private String id;
        private String name;
        private String config;
        private String role;
        private Boolean enabled;
        private Integer sort;
        private String pluginJar;
        private String namespaceId;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder config(String config) {
            this.config = config;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public Builder pluginJar(String pluginJar) {
            this.pluginJar = pluginJar;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public PluginData build() {
            PluginData pluginData = new PluginData();
            pluginData.setId(this.id);
            pluginData.setName(this.name);
            pluginData.setConfig(this.config);
            pluginData.setRole(this.role);
            pluginData.setEnabled(this.enabled);
            pluginData.setSort(this.sort);
            pluginData.setPluginJar(this.pluginJar);
            pluginData.setNamespaceId(this.namespaceId);
            return pluginData;
        }
    }
}

