/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.register.client.http.HttpClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.config.ShenyuDiscoveryConfig;
import org.apache.shenyu.register.common.dto.DiscoveryConfigRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public final class ClientDiscoveryConfigRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ClientDiscoveryConfigRefreshedEventListener.class);
    private final ShenyuDiscoveryConfig shenyuDiscoveryConfig;
    private final HttpClientRegisterRepository httpClientRegisterRepository;
    private final ClientRegisterConfig clientRegisterConfig;
    private final PluginEnum plugin;
    private final List<String> namespace;

    public ClientDiscoveryConfigRefreshedEventListener(ShenyuDiscoveryConfig shenyuDiscoveryConfig, HttpClientRegisterRepository httpClientRegisterRepository, ClientRegisterConfig clientRegisterConfig, PluginEnum plugin, ShenyuClientConfig shenyuClientConfig) {
        this.shenyuDiscoveryConfig = shenyuDiscoveryConfig;
        this.httpClientRegisterRepository = httpClientRegisterRepository;
        this.clientRegisterConfig = clientRegisterConfig;
        this.plugin = plugin;
        String namespace = shenyuClientConfig.getNamespace();
        if (StringUtils.isBlank((CharSequence)namespace)) {
            LOG.warn("current shenyu.namespace is null, use default namespace: {}", (Object)"649330b6-c2d7-4edc-be8e-8a54df9eb385");
            namespace = "649330b6-c2d7-4edc-be8e-8a54df9eb385";
        }
        this.namespace = Lists.newArrayList((Object[])StringUtils.split((String)namespace, (String)";"));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        List<String> namespaceIds = this.getNamespace();
        namespaceIds.forEach(namespaceId -> {
            DiscoveryConfigRegisterDTO discoveryConfigRegisterDTO = this.buildDiscoveryConfigRegisterDTO(this.shenyuDiscoveryConfig, (String)namespaceId);
            this.httpClientRegisterRepository.doPersistDiscoveryConfig(discoveryConfigRegisterDTO);
        });
    }

    protected DiscoveryConfigRegisterDTO buildDiscoveryConfigRegisterDTO(ShenyuDiscoveryConfig shenyuDiscoveryConfig, String namespaceId) {
        if (StringUtils.isEmpty((CharSequence)shenyuDiscoveryConfig.getServerList())) {
            LOG.error("If using service discovery. The configuration shenyu.discovery.name in xml/yml cannot be null");
            throw new ShenyuException("The configuration shenyu.discovery.serverList in xml/yml cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)shenyuDiscoveryConfig.getType())) {
            LOG.error("If using service discovery. The configuration shenyu.discovery.name in xml/yml cannot be null");
            throw new ShenyuException("The configuration shenyu.discovery.type in xml/yml cannot be null");
        }
        return DiscoveryConfigRegisterDTO.builder().name(this.discoveryName()).selectorName(this.clientRegisterConfig.getContextPath()).handler("{}").listenerNode(shenyuDiscoveryConfig.getRegisterPath()).serverList(shenyuDiscoveryConfig.getServerList()).props(shenyuDiscoveryConfig.getProps()).discoveryType(shenyuDiscoveryConfig.getType()).pluginName(this.plugin.getName()).namespaceId(namespaceId).build();
    }

    private String discoveryName() {
        return "default_" + this.shenyuDiscoveryConfig.getType();
    }

    public List<String> getNamespace() {
        return this.namespace;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

