/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.common;

import com.google.common.util.concurrent.ListenableFuture;
import com.tencentcloudapi.cls.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.producer.Callback;
import com.tencentcloudapi.cls.producer.Result;
import com.tencentcloudapi.cls.producer.common.ExpiredBatches;
import com.tencentcloudapi.cls.producer.common.LogItem;
import com.tencentcloudapi.cls.producer.common.LogSizeCalculator;
import com.tencentcloudapi.cls.producer.common.ProducerBatch;
import com.tencentcloudapi.cls.producer.common.RetryQueue;
import com.tencentcloudapi.cls.producer.common.SendProducerBatchTask;
import com.tencentcloudapi.cls.producer.common.SendThreadPool;
import com.tencentcloudapi.cls.producer.errors.LogSizeTooLargeException;
import com.tencentcloudapi.cls.producer.errors.ProducerException;
import com.tencentcloudapi.cls.producer.errors.TimeoutException;
import com.tencentcloudapi.cls.producer.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class LogAccumulator {
    private static final AtomicLong BATCH_ID = new AtomicLong(0L);
    private final String producerHash;
    private final AsyncProducerConfig producerConfig;
    private final AtomicInteger batchCount;
    private volatile boolean closed;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final AtomicInteger appendsInProgress;
    private final Semaphore memoryController;
    private final SendThreadPool sendThreadPool;
    private final ConcurrentMap<String, ProducerBatchHolder> batches;

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    private boolean appendsInProgress() {
        return this.appendsInProgress.get() > 0;
    }

    public LogAccumulator(String producerHash, AsyncProducerConfig producerConfig, Semaphore memoryController, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, AtomicInteger batchCount, SendThreadPool sendThreadPool) {
        this.producerHash = producerHash;
        this.producerConfig = producerConfig;
        this.memoryController = memoryController;
        this.batchCount = batchCount;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.sendThreadPool = sendThreadPool;
        this.appendsInProgress = new AtomicInteger(0);
        this.batches = new ConcurrentHashMap<String, ProducerBatchHolder>();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Result> append(String topicId, List<LogItem> logItems, Callback callback) throws InterruptedException, ProducerException {
        this.appendsInProgress.incrementAndGet();
        try {
            ListenableFuture<Result> listenableFuture = this.doAppend(topicId, logItems, callback);
            return listenableFuture;
        }
        finally {
            this.appendsInProgress.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Result> doAppend(String topicId, List<LogItem> logItems, Callback callback) throws InterruptedException, ProducerException {
        if (this.closed) {
            throw new IllegalStateException("cannot append after the log accumulator was closed");
        }
        int sizeInBytes = LogSizeCalculator.calculate(logItems);
        this.ensureValidLogSize(sizeInBytes);
        long maxBlockMs = this.producerConfig.getMaxBlockMs();
        if (maxBlockMs >= 0L) {
            boolean acquired = this.memoryController.tryAcquire(sizeInBytes, maxBlockMs, TimeUnit.MILLISECONDS);
            if (!acquired) {
                throw new TimeoutException("failed to acquire memory within the configured max blocking time " + this.producerConfig.getMaxBlockMs() + " ms");
            }
        } else {
            this.memoryController.acquire(sizeInBytes);
        }
        try {
            ProducerBatchHolder holder;
            ProducerBatchHolder producerBatchHolder = holder = this.getOrCreateProducerBatchHolder(topicId);
            synchronized (producerBatchHolder) {
                return this.appendToHolder(topicId, logItems, callback, sizeInBytes, holder);
            }
        }
        catch (Exception e) {
            this.memoryController.release(sizeInBytes);
            throw new ProducerException(e);
        }
    }

    private ProducerBatchHolder getOrCreateProducerBatchHolder(String TopicId) {
        ProducerBatchHolder holder = (ProducerBatchHolder)this.batches.get(TopicId);
        if (holder != null) {
            return holder;
        }
        holder = new ProducerBatchHolder();
        ProducerBatchHolder previous = this.batches.putIfAbsent(TopicId, holder);
        if (previous == null) {
            return holder;
        }
        return previous;
    }

    private ListenableFuture<Result> appendToHolder(String topicId, List<LogItem> logItems, Callback callback, int sizeInBytes, ProducerBatchHolder holder) {
        ListenableFuture<Result> f;
        if (holder.producerBatch != null) {
            f = holder.producerBatch.tryAppend(logItems, sizeInBytes, callback);
            if (f != null) {
                if (holder.producerBatch.isMeetSendCondition()) {
                    holder.transferProducerBatch(this.sendThreadPool, this.producerConfig, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
                }
                return f;
            }
            holder.transferProducerBatch(this.sendThreadPool, this.producerConfig, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
        }
        holder.producerBatch = new ProducerBatch(topicId, Utils.generatePackageId(this.producerHash, BATCH_ID), this.producerConfig.getBatchSizeThresholdInBytes(), this.producerConfig.getBatchCountThreshold(), this.producerConfig.getMaxReservedAttempts(), System.currentTimeMillis());
        f = holder.producerBatch.tryAppend(logItems, sizeInBytes, callback);
        this.batchCount.incrementAndGet();
        if (holder.producerBatch.isMeetSendCondition()) {
            holder.transferProducerBatch(this.sendThreadPool, this.producerConfig, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
        }
        return f;
    }

    private void ensureValidLogSize(int sizeInBytes) throws LogSizeTooLargeException {
        if (sizeInBytes > 0x500000) {
            throw new LogSizeTooLargeException("the logs is " + sizeInBytes + " bytes which is larger than MAX_BATCH_SIZE_IN_BYTES " + 0x500000);
        }
        if (sizeInBytes > this.producerConfig.getTotalSizeInBytes()) {
            throw new LogSizeTooLargeException("the logs is " + sizeInBytes + " bytes which is larger than the totalSizeInBytes you specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpiredBatches expiredBatches() {
        long nowMs = System.currentTimeMillis();
        ExpiredBatches expiredBatches = new ExpiredBatches();
        long remainingMs = this.producerConfig.getLingerMs();
        for (Map.Entry entry : this.batches.entrySet()) {
            ProducerBatchHolder holder;
            ProducerBatchHolder producerBatchHolder = holder = (ProducerBatchHolder)entry.getValue();
            synchronized (producerBatchHolder) {
                if (holder.producerBatch == null) {
                    continue;
                }
                long curRemainingMs = holder.producerBatch.remainingMs(nowMs, this.producerConfig.getLingerMs());
                if (curRemainingMs <= 0L) {
                    holder.transferProducerBatch(expiredBatches);
                } else {
                    remainingMs = Math.min(remainingMs, curRemainingMs);
                }
            }
        }
        expiredBatches.setRemainingMs(remainingMs);
        return expiredBatches;
    }

    public List<ProducerBatch> remainingBatches() {
        if (!this.closed) {
            throw new IllegalStateException("cannot get the remaining batches before the log accumulator closed");
        }
        ArrayList<ProducerBatch> remainingBatches = new ArrayList<ProducerBatch>();
        while (this.appendsInProgress()) {
            this.drainTo(remainingBatches);
        }
        this.drainTo(remainingBatches);
        this.batches.clear();
        return remainingBatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drainTo(List<ProducerBatch> c) {
        int n = 0;
        for (Map.Entry entry : this.batches.entrySet()) {
            ProducerBatchHolder holder;
            ProducerBatchHolder producerBatchHolder = holder = (ProducerBatchHolder)entry.getValue();
            synchronized (producerBatchHolder) {
                if (holder.producerBatch == null) {
                    continue;
                }
                c.add(holder.producerBatch);
                ++n;
                holder.producerBatch = null;
            }
        }
        return n;
    }

    public static final class ProducerBatchHolder {
        ProducerBatch producerBatch;

        void transferProducerBatch(SendThreadPool sendThreadPool, AsyncProducerConfig producerConfig, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, AtomicInteger batchCount) {
            if (this.producerBatch == null) {
                return;
            }
            sendThreadPool.submit(new SendProducerBatchTask(this.producerBatch, producerConfig, retryQueue, successQueue, failureQueue, batchCount));
            this.producerBatch = null;
        }

        void transferProducerBatch(ExpiredBatches expiredBatches) {
            if (this.producerBatch == null) {
                return;
            }
            expiredBatches.add(this.producerBatch);
            this.producerBatch = null;
        }
    }
}

