/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;

public class Counter
extends Metric {
    private double value;

    public Counter(String name, Map<String, String> labels, double value, long timestamp) {
        super(name, labels, timestamp);
        this.value = value;
    }

    @Override
    public Metric sum(Metric m) {
        this.value += m.value().doubleValue();
        return this;
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Generated
    public static CounterBuilder builder() {
        return new CounterBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter other = (Counter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Counter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Counter(super=" + super.toString() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public static class CounterBuilder {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> labels$key;
        @Generated
        private ArrayList<String> labels$value;
        @Generated
        private double value;
        @Generated
        private long timestamp;

        @Generated
        CounterBuilder() {
        }

        @Generated
        public CounterBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CounterBuilder label(String labelKey, String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return this;
        }

        @Generated
        public CounterBuilder labels(Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public CounterBuilder clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return this;
        }

        @Generated
        public CounterBuilder value(double value) {
            this.value = value;
            return this;
        }

        @Generated
        public CounterBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public Counter build() {
            Map<String, String> labels;
            switch (this.labels$key == null ? 0 : this.labels$key.size()) {
                case 0: {
                    labels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    labels = Collections.singletonMap(this.labels$key.get(0), this.labels$value.get(0));
                    break;
                }
                default: {
                    labels = new LinkedHashMap(this.labels$key.size() < 0x40000000 ? 1 + this.labels$key.size() + (this.labels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.labels$key.size(); ++$i) {
                        labels.put(this.labels$key.get($i), this.labels$value.get($i));
                    }
                    labels = Collections.unmodifiableMap(labels);
                }
            }
            return new Counter(this.name, labels, this.value, this.timestamp);
        }

        @Generated
        public String toString() {
            return "Counter.CounterBuilder(name=" + this.name + ", labels$key=" + this.labels$key + ", labels$value=" + this.labels$value + ", value=" + this.value + ", timestamp=" + this.timestamp + ")";
        }
    }
}

