/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.istio.api.security.v1beta1.Condition;
import io.fabric8.istio.api.security.v1beta1.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionFluentImpl<A extends ConditionFluent<A>>
extends BaseFluent<A>
implements ConditionFluent<A> {
    private String key;
    private List<String> notValues = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();

    public ConditionFluentImpl() {
    }

    public ConditionFluentImpl(Condition instance) {
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withNotValues(instance.getNotValues());
            this.withValues(instance.getValues());
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    @Override
    public Boolean hasKey() {
        return this.key != null;
    }

    @Override
    public A addToNotValues(int index, String item) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        this.notValues.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotValues(int index, String item) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        this.notValues.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotValues(String ... items) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.notValues.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotValues(Collection<String> items) {
        if (this.notValues == null) {
            this.notValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.notValues.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotValues(String ... items) {
        for (String item : items) {
            if (this.notValues == null) continue;
            this.notValues.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotValues(Collection<String> items) {
        for (String item : items) {
            if (this.notValues == null) continue;
            this.notValues.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotValues() {
        return this.notValues;
    }

    @Override
    public String getNotValue(int index) {
        return this.notValues.get(index);
    }

    @Override
    public String getFirstNotValue() {
        return this.notValues.get(0);
    }

    @Override
    public String getLastNotValue() {
        return this.notValues.get(this.notValues.size() - 1);
    }

    @Override
    public String getMatchingNotValue(Predicate<String> predicate) {
        for (String item : this.notValues) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotValue(Predicate<String> predicate) {
        for (String item : this.notValues) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotValues(List<String> notValues) {
        if (notValues != null) {
            this.notValues = new ArrayList<String>();
            for (String item : notValues) {
                this.addToNotValues(item);
            }
        } else {
            this.notValues = null;
        }
        return (A)this;
    }

    @Override
    public A withNotValues(String ... notValues) {
        if (this.notValues != null) {
            this.notValues.clear();
            this._visitables.remove((Object)"notValues");
        }
        if (notValues != null) {
            for (String item : notValues) {
                this.addToNotValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotValues() {
        return this.notValues != null && !this.notValues.isEmpty();
    }

    @Override
    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(String ... items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public String getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionFluentImpl that = (ConditionFluentImpl)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.notValues, that.notValues)) {
            return false;
        }
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.notValues, this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.notValues != null && !this.notValues.isEmpty()) {
            sb.append("notValues:");
            sb.append(this.notValues + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }
}

