/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSQLExecutor
implements InsertRequest,
UpdateRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchSQLExecutor.class);
    private final JDBCClient jdbcClient;
    private final List<PrepareRequest> prepareRequests;

    public void invoke(int maxBatchSqlSize) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("execute sql batch. sql by key size: {}", (Object)this.prepareRequests.size());
        }
        if (this.prepareRequests.size() == 0) {
            return;
        }
        String sql = this.prepareRequests.get(0).toString();
        ArrayList<PrepareRequest> bulkRequest = new ArrayList<PrepareRequest>(maxBatchSqlSize);
        try (Connection connection = this.jdbcClient.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int pendingCount = 0;
            for (PrepareRequest prepareRequest : this.prepareRequests) {
                SQLExecutor sqlExecutor = (SQLExecutor)prepareRequest;
                if (log.isDebugEnabled()) {
                    log.debug("Executing sql: {}", (Object)sql);
                    log.debug("SQL parameters: {}", sqlExecutor.getParam());
                }
                sqlExecutor.setParameters(preparedStatement);
                preparedStatement.addBatch();
                bulkRequest.add((PrepareRequest)sqlExecutor);
                if (bulkRequest.size() == maxBatchSqlSize) {
                    this.executeBatch(preparedStatement, maxBatchSqlSize, sql, bulkRequest);
                    bulkRequest.clear();
                    pendingCount = 0;
                    continue;
                }
                ++pendingCount;
            }
            if (pendingCount > 0) {
                this.executeBatch(preparedStatement, pendingCount, sql, bulkRequest);
                bulkRequest.clear();
            }
        }
    }

    private void executeBatch(PreparedStatement preparedStatement, int pendingCount, String sql, List<PrepareRequest> bulkRequest) throws SQLException {
        long start = System.currentTimeMillis();
        int[] executeBatchResults = preparedStatement.executeBatch();
        boolean isInsert = bulkRequest.get(0) instanceof InsertRequest;
        for (int i = 0; i < executeBatchResults.length; ++i) {
            if ((executeBatchResults[i] == 1 || executeBatchResults[i] == -2) && isInsert) {
                ((InsertRequest)bulkRequest.get(i)).onInsertCompleted();
                continue;
            }
            if (executeBatchResults[i] != 0 || isInsert) continue;
            ((UpdateRequest)bulkRequest.get(i)).onUpdateFailure();
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            long cost = end - start;
            log.debug("execute batch sql, batch size: {}, cost:{}ms, sql: {}", new Object[]{pendingCount, cost, sql});
        }
    }

    public void onInsertCompleted() {
        throw new UnexpectedException("BatchSQLExecutor.onInsertCompleted should not be called");
    }

    public void onUpdateFailure() {
        throw new UnexpectedException("BatchSQLExecutor.onUpdateFailure should not be called");
    }

    @Generated
    public BatchSQLExecutor(JDBCClient jdbcClient, List<PrepareRequest> prepareRequests) {
        this.jdbcClient = jdbcClient;
        this.prepareRequests = prepareRequests;
    }
}

