/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareFutureListener;
import com.linecorp.armeria.common.RequestContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ContextAwareFuture<T>
implements Future<T> {
    private final RequestContext context;
    private final Future<T> delegate;

    ContextAwareFuture(RequestContext context, Future<T> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }

    public Future<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        this.delegate.addListener(ContextAwareFutureListener.of(this.context, listener));
        return this;
    }

    @SafeVarargs
    public final Future<T> addListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        for (GenericFutureListener<? extends Future<? super T>> l : listeners) {
            this.delegate.addListener(ContextAwareFutureListener.of(this.context, l));
        }
        return this;
    }

    public Future<T> removeListener(GenericFutureListener<? extends Future<? super T>> listener) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final Future<T> removeListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    public Future<T> sync() throws InterruptedException {
        this.delegate.sync();
        return this;
    }

    public Future<T> syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public Future<T> await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.delegate.await(timeoutMillis);
    }

    public Future<T> awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.delegate.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.delegate.awaitUninterruptibly(timeoutMillis);
    }

    public T getNow() {
        return (T)this.delegate.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

