/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.model.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.extension.apiregions.launcher.LauncherProperties;
import org.apache.sling.feature.spi.context.ExtensionHandler;
import org.apache.sling.feature.spi.context.ExtensionHandlerContext;
import org.osgi.service.component.annotations.Component;

@Component
public class APIRegionsExtensionHandler
implements ExtensionHandler {
    private static final String REGION_FACTORY_PID = "org.apache.sling.feature.apiregions.factory~";
    private static final String PROP_idbsnver = "mapping.bundleid.bsnver";
    private static final String PROP_bundleFeatures = "mapping.bundleid.features";
    private static final String PROP_featureRegions = "mapping.featureid.regions";
    private static final String PROP_regionPackage = "mapping.region.packages";

    @Override
    public boolean handle(ExtensionHandlerContext context, Extension extension, Feature feature) throws Exception {
        if (!extension.getName().equals("api-regions") || extension.getType() != ExtensionType.JSON) {
            return false;
        }
        ApiRegions regions = ApiRegions.parse(extension.getJSONStructure().asJsonArray());
        String configPid = REGION_FACTORY_PID.concat(feature.getId().toMvnName().replace('-', '_'));
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(PROP_idbsnver, this.convert(LauncherProperties.getBundleIDtoBSNandVersionMap(feature, context.getArtifactProvider())));
        ((Dictionary)props).put(PROP_bundleFeatures, this.convert(LauncherProperties.getBundleIDtoFeaturesMap(feature)));
        ((Dictionary)props).put(PROP_featureRegions, this.convert(LauncherProperties.getFeatureIDtoRegionsMap(regions)));
        ((Dictionary)props).put(PROP_regionPackage, this.convert(LauncherProperties.getRegionNametoPackagesMap(regions)));
        context.addConfiguration(null, configPid, props);
        return true;
    }

    private String[] convert(Properties props) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.add(entry.getKey().toString().concat("=").concat(entry.getValue().toString()));
        }
        return result.toArray(new String[result.size()]);
    }
}

