/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.sling.settings.SlingSettingsService;

public class MockSettings implements SlingSettingsService {

    private final Set<String> runModes;

    public MockSettings(final String[] modes) {
        this.runModes = new HashSet<String>();
        this.runModes.addAll(Arrays.asList(modes));
    }

    public Set<String> getRunModes() {
        return this.runModes;
    }

    public URL getSlingHome() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getSlingHomePath() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getSlingId() {
        // TODO Auto-generated method stub
        return null;
    }

}
