/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.api.common.JobStatus;

public enum ApplicationStatus {
    SUCCEEDED(0),
    FAILED(1443),
    CANCELED(0),
    UNKNOWN(1445);

    private final int processExitCode;

    private ApplicationStatus(int exitCode) {
        this.processExitCode = exitCode;
    }

    public int processExitCode() {
        return this.processExitCode;
    }

    public static ApplicationStatus fromJobStatus(JobStatus jobStatus) {
        if (jobStatus == null) {
            return UNKNOWN;
        }
        switch (jobStatus) {
            case FAILED: {
                return FAILED;
            }
            case CANCELED: {
                return CANCELED;
            }
            case FINISHED: {
                return SUCCEEDED;
            }
        }
        return UNKNOWN;
    }
}

