/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.BooleanSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.IntegerSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.ObjectSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.StringSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.TupleSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;

@Internal
public class SummaryAggregatorFactory {
    public static <R extends Tuple> TupleSummaryAggregator<R> create(TupleTypeInfoBase<?> inType) {
        Aggregator[] columnAggregators = new Aggregator[inType.getArity()];
        for (int field = 0; field < inType.getArity(); ++field) {
            Class clazz = inType.getTypeAt(field).getTypeClass();
            columnAggregators[field] = SummaryAggregatorFactory.create(clazz);
        }
        return new TupleSummaryAggregator(columnAggregators);
    }

    public static <T, R> Aggregator<T, R> create(Class<T> type) {
        if (type == Long.class) {
            return new LongSummaryAggregator();
        }
        if (type == LongValue.class) {
            return new ValueSummaryAggregator.LongValueSummaryAggregator();
        }
        if (type == Integer.class) {
            return new IntegerSummaryAggregator();
        }
        if (type == IntValue.class) {
            return new ValueSummaryAggregator.IntegerValueSummaryAggregator();
        }
        if (type == Double.class) {
            return new DoubleSummaryAggregator();
        }
        if (type == DoubleValue.class) {
            return new ValueSummaryAggregator.DoubleValueSummaryAggregator();
        }
        if (type == Float.class) {
            return new FloatSummaryAggregator();
        }
        if (type == FloatValue.class) {
            return new ValueSummaryAggregator.FloatValueSummaryAggregator();
        }
        if (type == Short.class) {
            return new ShortSummaryAggregator();
        }
        if (type == ShortValue.class) {
            return new ValueSummaryAggregator.ShortValueSummaryAggregator();
        }
        if (type == Boolean.class) {
            return new BooleanSummaryAggregator();
        }
        if (type == BooleanValue.class) {
            return new ValueSummaryAggregator.BooleanValueSummaryAggregator();
        }
        if (type == String.class) {
            return new StringSummaryAggregator();
        }
        if (type == StringValue.class) {
            return new ValueSummaryAggregator.StringValueSummaryAggregator();
        }
        return new ObjectSummaryAggregator();
    }
}

