/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.hadoop.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.hadoop.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.hadoop.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.hadoop.shaded.org.apache.commons.math3.optim.OptimizationData;
import org.apache.hadoop.shaded.org.apache.commons.math3.optim.PointValuePair;
import org.apache.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.hadoop.shaded.org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GradientMultivariateOptimizer
extends MultivariateOptimizer {
    private MultivariateVectorFunction gradient;

    protected GradientMultivariateOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    protected double[] computeObjectiveGradient(double[] params) {
        return this.gradient.value(params);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        this.parseOptimizationData(optData);
        return super.optimize(optData);
    }

    private void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (!(data instanceof ObjectiveFunctionGradient)) continue;
            this.gradient = ((ObjectiveFunctionGradient)data).getObjectiveFunctionGradient();
            break;
        }
    }
}

