/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.deployment.application.EntryClassInformationProvider;
import org.apache.flink.client.deployment.application.JarManifestParser;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class FromClasspathEntryClassInformationProvider
implements EntryClassInformationProvider {
    private final String jobClassName;

    public static FromClasspathEntryClassInformationProvider create(String jobClassName, Iterable<URL> classpath) throws IOException, FlinkException {
        Preconditions.checkNotNull((Object)jobClassName, (String)"No job class name passed.");
        Preconditions.checkNotNull(classpath, (String)"No classpath passed.");
        if (!FromClasspathEntryClassInformationProvider.userClasspathContainsJobClass(jobClassName, classpath)) {
            throw new FlinkException(String.format("Could not find the provided job class (%s) in the user lib directory.", jobClassName));
        }
        return new FromClasspathEntryClassInformationProvider(jobClassName);
    }

    public static FromClasspathEntryClassInformationProvider createFromClasspath(Iterable<URL> classpath) throws IOException, FlinkException {
        return new FromClasspathEntryClassInformationProvider(FromClasspathEntryClassInformationProvider.extractJobClassFromUrlClasspath(classpath));
    }

    public static FromClasspathEntryClassInformationProvider createFromSystemClasspath() throws IOException, FlinkException {
        return new FromClasspathEntryClassInformationProvider(FromClasspathEntryClassInformationProvider.extractJobClassFromSystemClasspath());
    }

    public static FromClasspathEntryClassInformationProvider createWithJobClassAssumingOnSystemClasspath(String jobClassName) {
        return new FromClasspathEntryClassInformationProvider(jobClassName);
    }

    private FromClasspathEntryClassInformationProvider(String jobClassName) {
        this.jobClassName = (String)Preconditions.checkNotNull((Object)jobClassName, (String)"No job class name set.");
    }

    @Override
    public Optional<File> getJarFile() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getJobClassName() {
        return Optional.of(this.jobClassName);
    }

    @VisibleForTesting
    static Iterable<File> extractSystemClasspath() {
        String classpathPropertyValue = System.getProperty("java.class.path", "");
        String pathSeparator = System.getProperty("path.separator", ":");
        return Arrays.stream(classpathPropertyValue.split(pathSeparator)).filter(entry -> !StringUtils.isNullOrWhitespaceOnly((String)entry)).map(File::new).filter(File::isFile).filter(f -> FromClasspathEntryClassInformationProvider.isJarFilename(f.getName())).collect(Collectors.toList());
    }

    private static String extractJobClassFromSystemClasspath() throws FlinkException, IOException {
        return FromClasspathEntryClassInformationProvider.extractJobClassNameFromFileClasspath(FromClasspathEntryClassInformationProvider.extractSystemClasspath());
    }

    private static String extractJobClassFromUrlClasspath(Iterable<URL> classpath) throws IOException, FlinkException {
        List<File> jarFilesFromClasspath = StreamSupport.stream(classpath.spliterator(), false).map(url -> new File(url.getFile())).filter(f -> FromClasspathEntryClassInformationProvider.isJarFilename(f.getName())).collect(Collectors.toList());
        return FromClasspathEntryClassInformationProvider.extractJobClassNameFromFileClasspath(jarFilesFromClasspath);
    }

    private static String extractJobClassNameFromFileClasspath(Iterable<File> classpath) throws FlinkException, IOException {
        try {
            return JarManifestParser.findOnlyEntryClass(classpath).getEntryClass();
        }
        catch (NoSuchElementException e) {
            throw new FlinkException("No JAR found on classpath. Please provide a JAR explicitly.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new FlinkException("Multiple JAR archives with entry classes found on classpath. Please provide an entry class name.", (Throwable)e);
        }
    }

    private static boolean userClasspathContainsJobClass(String jobClassName, Iterable<URL> classpath) throws IOException {
        for (URL url : classpath) {
            if (!FromClasspathEntryClassInformationProvider.isJarFile(url)) continue;
            JarFile jarFile = new JarFile(url.getFile());
            Throwable throwable = null;
            try {
                if (!FromClasspathEntryClassInformationProvider.jarContainsJobClass(jobClassName, jarFile)) continue;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        return false;
    }

    private static boolean jarContainsJobClass(String jobClassName, JarFile jarFile) {
        return jarFile.stream().map(ZipEntry::getName).filter(fileName -> fileName.endsWith("class")).map(FileUtils::stripFileExtension).map(fileName -> fileName.replaceAll(Pattern.quote(File.separator), ".")).anyMatch(name -> name.equals(jobClassName));
    }

    private static boolean isJarFile(URL url) {
        return FromClasspathEntryClassInformationProvider.isJarFilename(url.getFile());
    }

    private static boolean isJarFilename(String filename) {
        return filename.endsWith(".jar");
    }
}

