/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleDependencyResolver.class)
public class LifecycleDependencyResolver {
    @Requirement
    private ProjectDependenciesResolver dependenciesResolver;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactFactory artifactFactory;

    public LifecycleDependencyResolver() {
    }

    public LifecycleDependencyResolver(ProjectDependenciesResolver projectDependenciesResolver, Logger logger) {
        this.dependenciesResolver = projectDependenciesResolver;
        this.logger = logger;
    }

    public static List<MavenProject> getProjects(MavenProject project, MavenSession session, boolean aggregator) {
        if (aggregator) {
            return session.getProjects();
        }
        return Collections.singletonList(project);
    }

    public void resolveProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        if (project.getDependencyArtifacts() == null) {
            try {
                project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
            }
            catch (InvalidDependencyVersionException e) {
                throw new LifecycleExecutionException(e);
            }
        }
        Set<org.apache.maven.artifact.Artifact> artifacts = this.getDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
        project.setResolvedArtifacts(artifacts);
        HashMap<String, org.apache.maven.artifact.Artifact> map = new HashMap<String, org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            map.put(artifact.getDependencyConflictId(), artifact);
        }
        for (org.apache.maven.artifact.Artifact artifact : project.getDependencyArtifacts()) {
            org.apache.maven.artifact.Artifact resolved;
            if (artifact.getFile() != null || (resolved = (org.apache.maven.artifact.Artifact)map.get(artifact.getDependencyConflictId())) == null) continue;
            artifact.setFile(resolved.getFile());
            artifact.setDependencyTrail(resolved.getDependencyTrail());
            artifact.setResolvedVersion(resolved.getVersion());
            artifact.setResolved(true);
        }
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<org.apache.maven.artifact.Artifact> projectArtifacts) throws LifecycleExecutionException {
        DependencyResolutionResult result;
        if (scopesToCollect == null) {
            scopesToCollect = Collections.emptySet();
        }
        if (scopesToResolve == null) {
            scopesToResolve = Collections.emptySet();
        }
        if (scopesToCollect.isEmpty() && scopesToResolve.isEmpty()) {
            return new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        }
        scopesToCollect = new HashSet<String>(scopesToCollect);
        scopesToCollect.addAll(scopesToResolve);
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, this.negate(scopesToCollect));
        ScopeDependencyFilter resolutionFilter = new ScopeDependencyFilter(null, this.negate(scopesToResolve));
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)collectionFilter, (DependencyFilter)resolutionFilter);
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)resolutionFilter, (DependencyFilter)new ReactorDependencyFilter(projectArtifacts));
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, session.getRepositorySession());
            request.setResolutionFilter((DependencyFilter)resolutionFilter);
            result = this.dependenciesResolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            result = e.getResult();
            if (aggregating && this.areAllDependenciesInReactor(session.getProjects(), result.getUnresolvedDependencies())) {
                this.logger.warn("The following dependencies could not be resolved at this point of the build but seem to be part of the reactor:");
                for (Dependency dependency : result.getUnresolvedDependencies()) {
                    this.logger.warn("o " + dependency);
                }
                this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
            }
            throw new LifecycleExecutionException(null, project, e);
        }
        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, result.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), (DependencyFilter)collectionFilter);
        }
        return artifacts;
    }

    private boolean areAllDependenciesInReactor(Collection<MavenProject> projects, Collection<Dependency> dependencies) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Dependency dependency : dependencies) {
            Artifact a = dependency.getArtifact();
            String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
            if (projectKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project : projects) {
            String key = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    private Collection<String> negate(Collection<String> scopes) {
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, "system", "compile", "provided", "runtime", "test");
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                continue;
            }
            if ("runtime".equals(scope)) {
                result.remove("compile");
                result.remove("runtime");
                continue;
            }
            if ("compile+runtime".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                result.remove("runtime");
                continue;
            }
            if ("runtime+system".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("runtime");
                continue;
            }
            if (!"test".equals(scope)) continue;
            result.clear();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReactorDependencyFilter
    implements DependencyFilter {
        private Set<String> keys = new HashSet<String>();

        public ReactorDependencyFilter(Collection<org.apache.maven.artifact.Artifact> artifacts) {
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                String key = ArtifactUtils.key((org.apache.maven.artifact.Artifact)artifact);
                this.keys.add(key);
            }
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            Dependency dependency = node.getDependency();
            if (dependency != null) {
                Artifact a = dependency.getArtifact();
                String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
                return !this.keys.contains(key);
            }
            return false;
        }
    }
}

