/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.decorators.ExternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;

public abstract class ServiceType {
    public Service buildUpExternalRestService(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        String serviceName = ExternalServiceDecorator.getExternalServiceName(kubernetesJobManagerParameters.getClusterId());
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceBuilder)new ServiceBuilder().withApiVersion("v1")).withNewMetadata().withName(serviceName)).withLabels(kubernetesJobManagerParameters.getCommonLabels())).withAnnotations(kubernetesJobManagerParameters.getRestServiceAnnotations())).endMetadata()).withNewSpec().withType(kubernetesJobManagerParameters.getRestServiceExposedType().serviceType().getType())).withSelector(kubernetesJobManagerParameters.getSelectors())).addNewPort().withName("rest")).withPort(kubernetesJobManagerParameters.getRestPort())).withNewTargetPort(kubernetesJobManagerParameters.getRestBindPort())).endPort()).endSpec()).build();
    }

    public abstract Service buildUpInternalService(KubernetesJobManagerParameters var1);

    public abstract String getType();

    public static KubernetesConfigOptions.ServiceExposedType classify(Service service) {
        KubernetesConfigOptions.ServiceExposedType type = KubernetesConfigOptions.ServiceExposedType.valueOf(service.getSpec().getType());
        if (type == KubernetesConfigOptions.ServiceExposedType.ClusterIP && "None".equals(service.getSpec().getClusterIP())) {
            type = KubernetesConfigOptions.ServiceExposedType.Headless_ClusterIP;
        }
        return type;
    }
}

