/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.console.core.entity.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_app_backup")
public class ApplicationBackUp {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBackUp.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long appId;
    private Long sqlId;
    private Long configId;
    private String path;
    private String description;
    private Integer version;
    private Date createTime;
    private transient boolean backup;
    private transient String teamId;

    public ApplicationBackUp() {
    }

    public ApplicationBackUp(Application application) {
        this.appId = application.getId();
        this.sqlId = application.getSqlId();
        this.configId = application.getConfigId();
        this.description = application.getBackUpDescription();
        this.createTime = new Date();
        switch (application.getExecutionModeEnum()) {
            case KUBERNETES_NATIVE_APPLICATION: 
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_PER_JOB: 
            case YARN_SESSION: 
            case REMOTE: 
            case LOCAL: {
                this.path = String.format("%s/%d/%d", Workspace.local().APP_BACKUPS(), application.getId(), this.createTime.getTime());
                break;
            }
            case YARN_APPLICATION: {
                this.path = String.format("%s/%d/%d", Workspace.remote().APP_BACKUPS(), application.getId(), this.createTime.getTime());
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported executionMode ".concat(application.getExecutionModeEnum().getName()));
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Long getSqlId() {
        return this.sqlId;
    }

    public Long getConfigId() {
        return this.configId;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setSqlId(Long sqlId) {
        this.sqlId = sqlId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
}

