/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.security.Authenticator;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"passport"})
public class PassportController {
    @Autowired
    private UserService userService;
    @Autowired
    private Authenticator authenticator;

    @PostMapping(value={"signin"})
    public RestResponse signin(HttpServletRequest request, HttpServletResponse response, @NotBlank(message="{required}") @NotBlank(message="{required}") String username, @NotBlank(message="{required}") @NotBlank(message="{required}") String password, @NotBlank(message="{required}") @NotBlank(message="{required}") String loginType) throws Exception {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return RestResponse.success().put("code", (Object)0);
        }
        User user = this.authenticator.authenticate(username, password, loginType);
        if (user == null) {
            return RestResponse.success().put("code", (Object)0);
        }
        if ("0".equals(user.getStatus())) {
            return RestResponse.success().put("code", (Object)1);
        }
        this.userService.fillInTeam(user);
        if (user.getLastTeamId() == null) {
            return RestResponse.success().data(user.getUserId()).put("code", (Object)ResponseCode.CODE_FORBIDDEN);
        }
        this.userService.updateLoginTime(username);
        String sign = JWTUtil.sign(user.getUserId(), username, user.getSalt(), AuthenticationType.SIGN);
        LocalDateTime expireTime = LocalDateTime.now().plusSeconds(JWTUtil.getTTLOfSecond());
        String ttl = DateUtils.formatFullTime((LocalDateTime)expireTime);
        JWTToken loginToken = new JWTToken(sign, ttl, AuthenticationType.SIGN.get());
        SecurityUtils.getSubject().login((AuthenticationToken)loginToken);
        String token = WebUtils.encryptToken(sign);
        JWTToken jwtToken = new JWTToken(token, ttl, AuthenticationType.SIGN.get());
        String userId = RandomStringUtils.randomAlphanumeric((int)20);
        user.setId(userId);
        Map<String, Object> userInfo = this.userService.generateFrontendUserInfo(user, user.getLastTeamId(), jwtToken);
        return new RestResponse().data(userInfo);
    }

    @Operation(summary="Signout")
    @PostMapping(value={"signout"})
    public RestResponse signout() {
        SecurityUtils.getSubject().logout();
        return new RestResponse();
    }
}

