/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.ingress.IngressController$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesRetriever$
implements Logger {
    public static final KubernetesRetriever$ MODULE$;
    private final Timeout FLINK_CLIENT_TIMEOUT_SEC;
    private final Timeout FLINK_REST_AWAIT_TIMEOUT_SEC;
    private final Map<String, Object> org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME;
    private final DefaultClusterClientServiceLoader clusterClientServiceLoader;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new KubernetesRetriever$();
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    public Timeout FLINK_CLIENT_TIMEOUT_SEC() {
        return this.FLINK_CLIENT_TIMEOUT_SEC;
    }

    public Timeout FLINK_REST_AWAIT_TIMEOUT_SEC() {
        return this.FLINK_REST_AWAIT_TIMEOUT_SEC;
    }

    public Map<String, Object> org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME() {
        return this.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME;
    }

    public KubernetesClient newK8sClient() throws KubernetesClientException {
        return new DefaultKubernetesClient();
    }

    public boolean checkK8sConnection() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return KubernetesRetriever$.MODULE$.newK8sClient().getVersion() != null;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private DefaultClusterClientServiceLoader clusterClientServiceLoader() {
        return this.clusterClientServiceLoader;
    }

    public Option<ClusterClient<String>> org$apache$streampark$flink$kubernetes$KubernetesRetriever$$newFinkClusterClient(String clusterId, @Nullable String namespace, Enumeration.Value executeMode) {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString(DeploymentOptions.TARGET, executeMode.toString());
        flinkConfig.setString(KubernetesConfigOptions.CLUSTER_ID, clusterId);
        flinkConfig.set(ClientOptions.CLIENT_TIMEOUT, ClientOptions.CLIENT_TIMEOUT.defaultValue());
        flinkConfig.set(RestOptions.AWAIT_LEADER_TIMEOUT, RestOptions.AWAIT_LEADER_TIMEOUT.defaultValue());
        flinkConfig.set(RestOptions.RETRY_MAX_ATTEMPTS, RestOptions.RETRY_MAX_ATTEMPTS.defaultValue());
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(namespace){
            public static final long serialVersionUID = 0L;
            private final String namespace$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.namespace$1.isEmpty();
            }
            {
                this.namespace$1 = namespace$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }))) {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, (String)KubernetesConfigOptions.NAMESPACE.defaultValue());
        } else {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, namespace);
        }
        ClusterClientFactory clientFactory = this.clusterClientServiceLoader().getClusterClientFactory(flinkConfig);
        KubernetesClusterDescriptor x$2 = (KubernetesClusterDescriptor)clientFactory.createClusterDescriptor(flinkConfig);
        Serializable x$3 = new Serializable(flinkConfig){
            public static final long serialVersionUID = 0L;
            public final Configuration flinkConfig$1;

            public final Option<ClusterClient<String>> apply(KubernetesClusterDescriptor clusterProvider) {
                Try try_;
                block4: {
                    Some some;
                    block3: {
                        block2: {
                            try_ = Try$.MODULE$.apply((Function0)new Serializable(this, clusterProvider){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.1 $outer;
                                private final KubernetesClusterDescriptor clusterProvider$1;

                                public final ClusterClient<String> apply() {
                                    return this.clusterProvider$1.retrieve(this.$outer.flinkConfig$1.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.clusterProvider$1 = clusterProvider$1;
                                }
                            });
                            if (!(try_ instanceof Success)) break block2;
                            Success success = (Success)try_;
                            ClusterClient v = (ClusterClient)success.value();
                            some = new Some((Object)v);
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        KubernetesRetriever$.MODULE$.logError((Function0<String>)new Serializable(this, e){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Get flinkClient error, the error is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1}));
                            }
                            {
                                this.e$1 = e$1;
                            }
                        });
                        some = None$.MODULE$;
                    }
                    return some;
                }
                throw new MatchError((Object)try_);
            }
            {
                this.flinkConfig$1 = flinkConfig$1;
            }
        };
        Utils$.MODULE$.using$default$3((AutoCloseable)x$2, (Function1)x$3);
        Object x$4 = null;
        return (Option)Utils$.MODULE$.using((AutoCloseable)x$2, (Function1)x$3, null);
    }

    public boolean isDeploymentExists(String namespace, String deploymentName) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                bl = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.using((AutoCloseable)this.newK8sClient(), (Function1)new Serializable(namespace, deploymentName){
                    public static final long serialVersionUID = 0L;
                    private final String namespace$2;
                    public final String deploymentName$1;

                    public final boolean apply(KubernetesClient client) {
                        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeploymentList)((Listable)((Filterable)client.apps().deployments().inNamespace(this.namespace$2)).withLabel("type", "flink-native-kubernetes")).list()).getItems()).asScala()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.isDeploymentExists.1 $outer;

                            public final boolean apply(Deployment x$1) {
                                String string = x$1.getMetadata().getName();
                                String string2 = this.$outer.deploymentName$1;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.namespace$2 = namespace$2;
                        this.deploymentName$1 = deploymentName$1;
                    }
                }, (Function1)new Serializable(namespace, deploymentName, object){
                    public static final long serialVersionUID = 0L;
                    public final String namespace$2;
                    public final String deploymentName$1;
                    private final Object nonLocalReturnKey1$1;

                    public final boolean apply(Throwable e) {
                        KubernetesRetriever$.MODULE$.logWarn((Function0<String>)new Serializable(this, e){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.isDeploymentExists.2 $outer;
                            private final Throwable e$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |[StreamPark] check deploymentExists WARN,\n             |namespace: ", ",\n             |deploymentName: ", ",\n             |error: ", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.namespace$2, this.$outer.deploymentName$1, this.e$2})))).stripMargin();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.e$2 = e$2;
                            }
                        });
                        String key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.namespace$2, this.deploymentName$1}));
                        Option option = KubernetesRetriever$.MODULE$.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME().get((Object)key);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long time = BoxesRunTime.unboxToLong((Object)some.x());
                            long timeOut = 180000L;
                            if (System.currentTimeMillis() - time >= timeOut) {
                                KubernetesRetriever$.MODULE$.logError((Function0<String>)new Serializable(this, e){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.isDeploymentExists.2 $outer;
                                    private final Throwable e$2;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   |[StreamPark] check deploymentExists Failed,\n                   |namespace: ", ",\n                   |deploymentName: ", ",\n                   |detail: deployment: ", " Not Found more than 3 minutes, ", "\n                   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.namespace$2, this.$outer.deploymentName$1, this.$outer.deploymentName$1, this.e$2})))).stripMargin();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.e$2 = e$2;
                                    }
                                });
                                KubernetesRetriever$.MODULE$.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME().$minus$eq((Object)key);
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                            }
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                        KubernetesRetriever$.MODULE$.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.namespace$2 = namespace$2;
                        this.deploymentName$1 = deploymentName$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public Option<String> retrieveFlinkRestUrl(ClusterKey clusterKey) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                String url = IngressController$.MODULE$.getIngressUrl(clusterKey.namespace(), clusterKey.clusterId(), (Function0<ClusterClient<?>>)new Serializable(clusterKey, object){
                    public static final long serialVersionUID = 0L;
                    private final ClusterKey clusterKey$1;
                    public final Object nonLocalReturnKey2$1;

                    public final ClusterClient<String> apply() {
                        return (ClusterClient)KubernetesRetriever$.MODULE$.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$newFinkClusterClient(this.clusterKey$1.clusterId(), this.clusterKey$1.namespace(), this.clusterKey$1.executeMode()).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.3 $outer;

                            public final Nothing$ apply() {
                                throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey2$1, (Object)None$.MODULE$);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.clusterKey$1 = clusterKey$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"retrieve flink jobManager rest url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
                option = new Some((Object)url);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public String getSessionClusterIngressURL(String namespace, String clusterId) {
        return (String)this.retrieveFlinkRestUrl(new ClusterKey(FlinkK8sExecuteMode$.MODULE$.SESSION(), namespace, clusterId)).orNull(Predef$.MODULE$.$conforms());
    }

    private KubernetesRetriever$() {
        MODULE$ = this;
        Logger.class.$init$((Logger)this);
        this.FLINK_CLIENT_TIMEOUT_SEC = Timeout.ofMilliseconds((long)((Duration)ClientOptions.CLIENT_TIMEOUT.defaultValue()).toMillis());
        this.FLINK_REST_AWAIT_TIMEOUT_SEC = Timeout.ofMilliseconds((long)Predef$.MODULE$.Long2long((Long)RestOptions.AWAIT_LEADER_TIMEOUT.defaultValue()));
        this.org$apache$streampark$flink$kubernetes$KubernetesRetriever$$DEPLOYMENT_LOST_TIME = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }
}

