/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.util.Preconditions;

public class SlotSharingGroupUtils {
    public static ResourceSpec extractResourceSpec(SlotSharingGroup slotSharingGroup) {
        if (!slotSharingGroup.getCpuCores().isPresent()) {
            return ResourceSpec.UNKNOWN;
        }
        Preconditions.checkState(slotSharingGroup.getCpuCores().isPresent());
        Preconditions.checkState(slotSharingGroup.getTaskHeapMemory().isPresent());
        Preconditions.checkState(slotSharingGroup.getTaskOffHeapMemory().isPresent());
        Preconditions.checkState(slotSharingGroup.getManagedMemory().isPresent());
        return ResourceSpec.newBuilder((double)slotSharingGroup.getCpuCores().get(), slotSharingGroup.getTaskHeapMemory().get()).setTaskOffHeapMemory(slotSharingGroup.getTaskOffHeapMemory().get()).setManagedMemory(slotSharingGroup.getManagedMemory().get()).setExtendedResources(slotSharingGroup.getExternalResources().entrySet().stream().map(entry -> new ExternalResource((String)entry.getKey(), (Double)entry.getValue())).collect(Collectors.toList())).build();
    }
}

