/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.HadoopConfigUtils$;
import org.apache.streampark.common.util.HadoopUtils$;
import org.apache.streampark.common.util.HttpClientUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.common.util.YarnUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class YarnUtils$
implements Logger {
    public static final YarnUtils$ MODULE$;
    public String org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
    private String PROXY_YARN_URL;
    private boolean hasYarnHttpKerberosAuth;
    private boolean hasYarnHttpSimpleAuth;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new YarnUtils$();
    }

    private String PROXY_YARN_URL$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PROXY_YARN_URL = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_PROXY_YARN_URL());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.PROXY_YARN_URL;
        }
    }

    private boolean hasYarnHttpKerberosAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpKerberosAuth = "kerberos".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.hasYarnHttpKerberosAuth;
        }
    }

    private boolean hasYarnHttpSimpleAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpSimpleAuth = "simple".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.hasYarnHttpSimpleAuth;
        }
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    private String PROXY_YARN_URL() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PROXY_YARN_URL$lzycompute() : this.PROXY_YARN_URL;
    }

    public boolean hasYarnHttpKerberosAuth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hasYarnHttpKerberosAuth$lzycompute() : this.hasYarnHttpKerberosAuth;
    }

    public boolean hasYarnHttpSimpleAuth() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hasYarnHttpSimpleAuth$lzycompute() : this.hasYarnHttpSimpleAuth;
    }

    public List<ApplicationId> getAppId(String appName) {
        Buffer buffer;
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.RUNNING, YarnApplicationState.ACCEPTED, YarnApplicationState.SUBMITTED);
        try {
            buffer = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(HadoopUtils$.MODULE$.yarnClient().getApplications(appStates)).filter((Function1)new Serializable(appName){
                public static final long serialVersionUID = 0L;
                private final String appName$1;

                public final boolean apply(ApplicationReport x$1) {
                    String string = x$1.getName();
                    String string2 = this.appName$1;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.appName$1 = appName$1;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ApplicationId apply(ApplicationReport x$2) {
                    return x$2.getApplicationId();
                }
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            buffer = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
        Buffer appIds = buffer;
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)appIds.toList());
    }

    /*
     * WARNING - void declaration
     */
    public YarnApplicationState getState(String appId) {
        void var3_5;
        YarnApplicationState yarnApplicationState;
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appId);
        try {
            ApplicationReport applicationReport = HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId);
            yarnApplicationState = applicationReport.getYarnApplicationState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            yarnApplicationState = null;
        }
        YarnApplicationState state = yarnApplicationState;
        return var3_5;
    }

    public boolean isContains(String appName) {
        List runningApps = HadoopUtils$.MODULE$.yarnClient().getApplications(EnumSet.of(YarnApplicationState.RUNNING));
        return runningApps == null ? false : JavaConversions$.MODULE$.asScalaBuffer(runningApps).exists((Function1)new Serializable(appName){
            public static final long serialVersionUID = 0L;
            private final String appName$2;

            public final boolean apply(ApplicationReport x$3) {
                String string = x$3.getName();
                String string2 = this.appName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.appName$2 = appName$2;
            }
        });
    }

    public String getRMWebAppProxyURL() {
        return StringUtils.isNotBlank((CharSequence)this.PROXY_YARN_URL()) ? this.PROXY_YARN_URL() : this.getRMWebAppURL(this.getRMWebAppURL$default$1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRMWebAppURL(boolean getLatest) {
        if (!getLatest && this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL != null) return this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            Tuple3 tuple3;
            block4: {
                Tuple3 tuple32;
                Configuration conf = HadoopUtils$.MODULE$.hadoopConf();
                Tuple3 tuple33 = tuple3 = YarnConfiguration.useHttps((Configuration)conf) ? new Tuple3((Object)"yarn.resourcemanager.webapp.https.address", (Object)BoxesRunTime.boxToInteger((int)8090), (Object)"https://") : new Tuple3((Object)"yarn.resourcemanager.webapp.address", (Object)BoxesRunTime.boxToInteger((int)8088), (Object)"http://");
                if (tuple3 == null) break block4;
                String webConfKey = (String)tuple3._1();
                int defaultPort = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String protocol = (String)tuple3._3();
                Tuple3 tuple34 = tuple32 = new Tuple3((Object)webConfKey, (Object)BoxesRunTime.boxToInteger((int)defaultPort), (Object)protocol);
                String webConfKey2 = (String)tuple34._1();
                int defaultPort2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
                String protocol2 = (String)tuple34._3();
                this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL = new StringBuilder().append((Object)protocol2).append(Option$.MODULE$.apply((Object)conf.get("yarn.web-proxy.address", null)).getOrElse((Function0)new Serializable(conf, webConfKey2, defaultPort2, protocol2){
                    public static final long serialVersionUID = 0L;
                    private final Configuration conf$1;
                    private final String webConfKey$1;
                    private final int defaultPort$1;
                    private final String protocol$1;

                    public final String apply() {
                        String string;
                        String addrKey = HAUtil.isHAEnabled((Configuration)this.conf$1) ? YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$getAddressConfKey$1(this.conf$1, this.webConfKey$1, this.defaultPort$1, this.protocol$1) : this.webConfKey$1;
                        InetSocketAddress socketAddr = this.conf$1.getSocketAddr(addrKey, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.0.0.0:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.defaultPort$1)})), this.defaultPort$1);
                        InetSocketAddress address = NetUtils.getConnectAddress((InetSocketAddress)socketAddr);
                        InetAddress resolved = address.getAddress();
                        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
                            String string2;
                            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return InetAddress.getLocalHost().getCanonicalHostName();
                                }
                            });
                            if (try_ instanceof Success) {
                                String value;
                                Success success = (Success)try_;
                                string2 = value = (String)success.value();
                            } else {
                                string2 = address.getHostName();
                            }
                            string = string2;
                        } else {
                            string = address.getHostName();
                        }
                        String hostName = string;
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)address.getPort())}));
                    }
                    {
                        this.conf$1 = conf$1;
                        this.webConfKey$1 = webConfKey$1;
                        this.defaultPort$1 = defaultPort$1;
                        this.protocol$1 = protocol$1;
                    }
                })).toString();
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarn resourceManager webapp url:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$rmHttpURL}));
                    }
                });
                return this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
            }
            throw new MatchError((Object)tuple3);
        }
    }

    public boolean getRMWebAppURL$default$1() {
        return false;
    }

    public String restRequest(String url, int timeout) throws IOException {
        Try try_;
        block12: {
            Try try_2;
            block13: {
                String string;
                block9: {
                    String string2;
                    block11: {
                        String v;
                        String string3;
                        block10: {
                            String v2;
                            block7: {
                                Try try_3;
                                String string4;
                                block8: {
                                    String v3;
                                    String string5;
                                    if (url == null) {
                                        return null;
                                    }
                                    string4 = url;
                                    if (!string4.matches("^http(|s)://.*")) break block7;
                                    try_3 = Try$.MODULE$.apply((Function0)new Serializable(url, timeout){
                                        public static final long serialVersionUID = 0L;
                                        private final String url$1;
                                        private final int timeout$1;

                                        public final String apply() {
                                            return YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$request(this.url$1, this.timeout$1);
                                        }
                                        {
                                            this.url$1 = url$1;
                                            this.timeout$1 = timeout$1;
                                        }
                                    });
                                    if (!(try_3 instanceof Success)) break block8;
                                    Success success = (Success)try_3;
                                    string = string5 = (v3 = (String)success.value());
                                    break block9;
                                }
                                if (try_3 instanceof Failure) {
                                    Failure failure = (Failure)try_3;
                                    Throwable e = failure.exception();
                                    if (this.hasYarnHttpKerberosAuth()) {
                                        throw new ConnectException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarnUtils authRestRequest error, url: ", ", detail: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string4, e})));
                                    }
                                    throw new ConnectException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarnUtils restRequest error, url: ", ", detail: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string4, e})));
                                }
                                throw new MatchError((Object)try_3);
                            }
                            try_ = Try$.MODULE$.apply((Function0)new Serializable(url, timeout){
                                public static final long serialVersionUID = 0L;
                                private final String url$1;
                                private final int timeout$1;

                                public final String apply() {
                                    return YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$request(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{YarnUtils$.MODULE$.getRMWebAppURL(YarnUtils$.MODULE$.getRMWebAppURL$default$1()), this.url$1})), this.timeout$1);
                                }
                                {
                                    this.url$1 = url$1;
                                    this.timeout$1 = timeout$1;
                                }
                            });
                            if (!(try_ instanceof Success)) break block10;
                            Success success = (Success)try_;
                            string2 = v2 = (String)success.value();
                            break block11;
                        }
                        if (!(try_ instanceof Failure)) break block12;
                        try_2 = Utils$.MODULE$.retry(5, Utils$.MODULE$.retry$default$2(), new Serializable(url, timeout){
                            public static final long serialVersionUID = 0L;
                            private final String url$1;
                            private final int timeout$1;

                            public final String apply() {
                                return YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$request(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{YarnUtils$.MODULE$.getRMWebAppURL(true), this.url$1})), this.timeout$1);
                            }
                            {
                                this.url$1 = url$1;
                                this.timeout$1 = timeout$1;
                            }
                        });
                        if (!(try_2 instanceof Success)) break block13;
                        Success success = (Success)try_2;
                        string2 = string3 = (v = (String)success.value());
                    }
                    string = string2;
                }
                return string;
            }
            if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                throw new ConnectException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarnUtils restRequest retry 5 times all failed. detail: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
            }
            throw new MatchError(try_2);
        }
        throw new MatchError((Object)try_);
    }

    public int restRequest$default$2() {
        return 5000;
    }

    public String org$apache$streampark$common$util$YarnUtils$$request(String reqUrl, int timeout) {
        String string;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).build();
        if (this.hasYarnHttpKerberosAuth()) {
            string = (String)HadoopUtils$.MODULE$.getUgi().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(reqUrl, config){
                private final String reqUrl$1;
                private final RequestConfig config$1;

                public String run() {
                    return HttpClientUtils$.MODULE$.httpAuthGetRequest(this.reqUrl$1, this.config$1);
                }
                {
                    this.reqUrl$1 = reqUrl$1;
                    this.config$1 = config$1;
                }
            });
        } else {
            String url = this.hasYarnHttpSimpleAuth() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?user.name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reqUrl, HadoopConfigUtils$.MODULE$.hadoopUserName()})) : reqUrl;
            string = HttpClientUtils$.MODULE$.httpGetRequest(url, config);
        }
        return string;
    }

    private final String findActiveRMId$1(YarnConfiguration yarnConf, Configuration conf$1, String webConfKey$1, int defaultPort$1, String protocol$1) {
        String string;
        Option option = Option$.MODULE$.apply((Object)RMHAUtils.findActiveRMHAId((Configuration)yarnConf));
        if (option instanceof Some) {
            Some some = (Some)option;
            String rmId = (String)some.x();
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "findActiveRMHAId successful";
                }
            });
            string = rmId;
        } else {
            this.logWarn((Function0<String>)new Serializable(yarnConf){
                public static final long serialVersionUID = 0L;
                private final YarnConfiguration yarnConf$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"findActiveRMHAId is null, config yarn.acl.enable:", ",now http try it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.yarnConf$1.get("yarn.acl.enable")}));
                }
                {
                    this.yarnConf$1 = yarnConf$1;
                }
            });
            int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
            string = (String)JavaConversions$.MODULE$.collectionAsScalaIterable(HAUtil.getRMHAIds((Configuration)conf$1)).find((Function1)new Serializable(conf$1, webConfKey$1, defaultPort$1, protocol$1, rpcTimeoutForChecks){
                public static final long serialVersionUID = 0L;
                public final Configuration conf$1;
                private final String webConfKey$1;
                public final int defaultPort$1;
                private final String protocol$1;
                private final int rpcTimeoutForChecks$1;

                public final boolean apply(String id) {
                    String url = new StringBuilder().append((Object)this.protocol$1).append(Option$.MODULE$.apply((Object)this.conf$1.get(HAUtil.addSuffix((String)this.webConfKey$1, (String)id))).getOrElse((Function0)new Serializable(this, id){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.findActiveRMId.1.3 $outer;
                        private final String id$1;

                        public final String apply() {
                            String hostname = this.$outer.conf$1.get(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)this.id$1));
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostname, BoxesRunTime.boxToInteger((int)this.$outer.defaultPort$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.id$1 = id$1;
                        }
                    })).toString();
                    return HttpClientUtils$.MODULE$.tryCheckUrl(url, this.rpcTimeoutForChecks$1);
                }
                {
                    this.conf$1 = conf$1;
                    this.webConfKey$1 = webConfKey$1;
                    this.defaultPort$1 = defaultPort$1;
                    this.protocol$1 = protocol$1;
                    this.rpcTimeoutForChecks$1 = rpcTimeoutForChecks$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IOException("[StreamPark] YarnUtils.getRMWebAppURL: can not found yarn active node");
                }
            });
        }
        return string;
    }

    public final String org$apache$streampark$common$util$YarnUtils$$getAddressConfKey$1(Configuration conf$1, String webConfKey$1, int defaultPort$1, String protocol$1) {
        Tuple2 tuple2;
        block4: {
            String string;
            block3: {
                block2: {
                    YarnConfiguration yarnConf = new YarnConfiguration(conf$1);
                    String activeRMId = this.findActiveRMId$1(yarnConf, conf$1, webConfKey$1, defaultPort$1, protocol$1);
                    this.logInfo((Function0<String>)new Serializable(activeRMId){
                        public static final long serialVersionUID = 0L;
                        private final String activeRMId$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current activeRMHAId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.activeRMId$1}));
                        }
                        {
                            this.activeRMId$1 = activeRMId$1;
                        }
                    });
                    String activeRMKey = HAUtil.addSuffix((String)webConfKey$1, (String)activeRMId);
                    String hostRMKey = HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)activeRMId);
                    tuple2 = new Tuple2((Object)activeRMKey, (Object)hostRMKey);
                    if (tuple2 == null) break block2;
                    String key = (String)tuple2._1();
                    String host = (String)tuple2._2();
                    if (HAUtil.getConfValueForRMInstance((String)key, (Configuration)yarnConf) != null || HAUtil.getConfValueForRMInstance((String)host, (Configuration)yarnConf) == null) break block2;
                    this.logInfo((Function0<String>)new Serializable(host){
                        public static final long serialVersionUID = 0L;
                        private final String host$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find rm web address by : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1}));
                        }
                        {
                            this.host$1 = host$1;
                        }
                    });
                    string = host;
                    break block3;
                }
                if (tuple2 == null) break block4;
                String key = (String)tuple2._1();
                this.logInfo((Function0<String>)new Serializable(key){
                    public static final long serialVersionUID = 0L;
                    private final String key$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find rm web address by : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1}));
                    }
                    {
                        this.key$1 = key$1;
                    }
                });
                string = key;
            }
            return string;
        }
        throw new MatchError((Object)tuple2);
    }

    private YarnUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

