/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import {
    DataExplorerWidgetModel,
    DataViewDataExplorerService,
} from '@streampipes/platform-services';
import { Router } from '@angular/router';

@Component({
    selector: 'sp-data-explorer-data-view-selection',
    templateUrl: './data-view-selection.component.html',
    styleUrls: ['./data-view-selection.component.scss'],
})
export class DataExplorerDataViewSelectionComponent implements OnInit {
    @Output()
    addDataViewEmitter: EventEmitter<string> = new EventEmitter();

    dataViews: DataExplorerWidgetModel[] = [];

    constructor(
        private dataViewService: DataViewDataExplorerService,
        private router: Router,
    ) {}

    ngOnInit() {
        this.dataViewService.getAllWidgets().subscribe(dataViews => {
            this.dataViews = dataViews.sort((a, b) =>
                a.baseAppearanceConfig.widgetTitle.localeCompare(
                    b.baseAppearanceConfig.widgetTitle,
                ),
            );
        });
    }

    navigateToDataViewCreation(): void {
        this.router.navigate(['dataexplorer', 'data-view'], {
            queryParams: { editMode: true },
            state: { omitConfirm: true },
        });
    }
}
