/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.csrf;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.csrf.CsrfAttacksPreventionProperties;
import org.apache.wicket.protocol.http.CsrfPreventionRequestCycleListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.csrf", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={CsrfPreventionRequestCycleListener.class})
@EnableConfigurationProperties(value={CsrfAttacksPreventionProperties.class})
public class CsrfAttacksPreventionConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private CsrfAttacksPreventionProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        CsrfPreventionRequestCycleListener listener = new CsrfPreventionRequestCycleListener();
        listener.setConflictingOriginAction(this.props.getConflictingOriginAction());
        listener.setErrorCode(this.props.getErrorCode());
        listener.setErrorMessage(this.props.getErrorMessage());
        listener.setNoOriginAction(this.props.getNoOriginAction());
        for (String acceptedOrigin : this.props.getAcceptedOrigins()) {
            listener.addAcceptedOrigin(acceptedOrigin);
        }
        webApplication.getRequestCycleListeners().add((Object)listener);
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

