/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TerminateSessionAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateSessionAction.class);
    public static final String REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED = "LogoutRequestConfirmed";
    protected final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    protected final CasCookieBuilder warnCookieGenerator;
    protected final LogoutProperties logoutProperties;
    protected final LogoutManager logoutManager;
    protected final ConfigurableApplicationContext applicationContext;
    protected final SingleLogoutRequestExecutor singleLogoutRequestExecutor;

    protected static boolean isLogoutRequestConfirmed(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameterMap().containsKey(REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED);
    }

    protected static void destroyApplicationSession(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("Destroying application session");
        JEEContext context = new JEEContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        manager.removeProfiles();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Object requestedUrl = session.getAttribute("pac4jRequestedUrl");
            session.invalidate();
            if (requestedUrl != null && !requestedUrl.equals("")) {
                request.getSession(true).setAttribute("pac4jRequestedUrl", requestedUrl);
            }
        }
    }

    public Event doExecute(RequestContext requestContext) throws Exception {
        Boolean terminateSession = (Boolean)FunctionUtils.doIf((boolean)this.logoutProperties.isConfirmLogout(), () -> TerminateSessionAction.isLogoutRequestConfirmed(requestContext), () -> Boolean.TRUE).get();
        if (terminateSession.booleanValue()) {
            return this.terminate(requestContext);
        }
        return this.eventFactorySupport.event((Object)this, "warn");
    }

    protected String getTicketGrantingTicket(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }

    protected Event terminate(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String tgtId = this.getTicketGrantingTicket(context);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            LOGGER.trace("Destroying SSO session linked to ticket-granting ticket [{}]", (Object)tgtId);
            List<SingleLogoutRequestContext> logoutRequests = this.initiateSingleLogout(tgtId, request, response);
            WebUtils.putLogoutRequests((RequestContext)context, logoutRequests);
        }
        LOGGER.trace("Removing CAS cookies");
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        this.warnCookieGenerator.removeCookie(response);
        TerminateSessionAction.destroyApplicationSession(request, response);
        LOGGER.debug("Terminated all CAS sessions successfully.");
        if (StringUtils.isNotBlank((CharSequence)this.logoutProperties.getRedirectUrl())) {
            WebUtils.putLogoutRedirectUrl((RequestContext)context, (String)this.logoutProperties.getRedirectUrl());
            return this.eventFactorySupport.event((Object)this, "redirect");
        }
        return this.eventFactorySupport.success((Object)this);
    }

    protected List<SingleLogoutRequestContext> initiateSingleLogout(String ticketGrantingTicketId, HttpServletRequest request, HttpServletResponse response) {
        return this.singleLogoutRequestExecutor.execute(ticketGrantingTicketId, request, response);
    }

    @Generated
    public TerminateSessionAction(CentralAuthenticationService centralAuthenticationService, CasCookieBuilder ticketGrantingTicketCookieGenerator, CasCookieBuilder warnCookieGenerator, LogoutProperties logoutProperties, LogoutManager logoutManager, ConfigurableApplicationContext applicationContext, SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.logoutProperties = logoutProperties;
        this.logoutManager = logoutManager;
        this.applicationContext = applicationContext;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }
}

