/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.api.DmnDecisionQuery;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;

public class GetDecisionsForProcessDefinitionCmd
implements Command<List<DmnDecision>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected DmnRepositoryService dmnRepositoryService;

    public GetDecisionsForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<DmnDecision> execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition for id: " + this.processDefinitionId, ProcessDefinition.class);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        if (bpmnModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find bpmn model for process definition id: " + this.processDefinitionId, BpmnModel.class);
        }
        if (CommandContextUtil.getDmnRepositoryService() == null) {
            throw new FlowableException("DMN repository service is not available");
        }
        this.dmnRepositoryService = CommandContextUtil.getDmnRepositoryService();
        List<DmnDecision> decisions = this.getDecisionsFromModel(bpmnModel, processDefinition);
        return decisions;
    }

    protected List<DmnDecision> getDecisionsFromModel(BpmnModel bpmnModel, ProcessDefinition processDefinition) {
        HashSet<String> decisionKeys = new HashSet<String>();
        ArrayList<DmnDecision> decisions = new ArrayList<DmnDecision>();
        List serviceTasks = bpmnModel.getMainProcess().findFlowElementsOfType(ServiceTask.class, true);
        block0: for (ServiceTask serviceTask : serviceTasks) {
            if (!"dmn".equals(serviceTask.getType()) || serviceTask.getFieldExtensions() == null || serviceTask.getFieldExtensions().size() <= 0) continue;
            for (FieldExtension fieldExtension : serviceTask.getFieldExtensions()) {
                if (!"decisionTableReferenceKey".equals(fieldExtension.getFieldName())) continue;
                String decisionReferenceKey = fieldExtension.getStringValue();
                if (decisionKeys.contains(decisionReferenceKey)) continue block0;
                this.addDecisionToCollection(decisions, decisionReferenceKey, processDefinition);
                decisionKeys.add(decisionReferenceKey);
                continue block0;
            }
        }
        return decisions;
    }

    protected void addDecisionToCollection(List<DmnDecision> decisions, String decisionKey, ProcessDefinition processDefinition) {
        DmnDecisionQuery definitionQuery = this.dmnRepositoryService.createDecisionQuery().decisionKey(decisionKey);
        Deployment deployment = (Deployment)CommandContextUtil.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
        if (deployment.getParentDeploymentId() != null) {
            List dmnDeployments = this.dmnRepositoryService.createDeploymentQuery().parentDeploymentId(deployment.getParentDeploymentId()).list();
            if (dmnDeployments != null && dmnDeployments.size() > 0) {
                definitionQuery.deploymentId(((DmnDeployment)dmnDeployments.get(0)).getId());
            } else {
                definitionQuery.latestVersion();
            }
        } else {
            definitionQuery.latestVersion();
        }
        DmnDecision decision = (DmnDecision)definitionQuery.singleResult();
        if (decision != null) {
            decisions.add(decision);
        }
    }
}

