/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Endpoint(id="loggingConfig", enableByDefault=false)
public class LoggingConfigurationEndpoint
extends BaseCasActuatorEndpoint
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConfigurationEndpoint.class);
    private static final String LOGGER_NAME_ROOT = "root";
    private static final String FILE_PARAM = "file";
    private static final String FILE_PATTERN_PARAM = "filePattern";
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private LoggerContext loggerContext;
    private Resource logConfigurationFile;

    public LoggingConfigurationEndpoint(CasConfigurationProperties casProperties, ResourceLoader resourceLoader, Environment environment) {
        super(casProperties);
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }

    private static ILoggerFactory getCasLoggerFactoryInstance() {
        return LoggerFactory.getILoggerFactory();
    }

    private static Optional<Pair<Resource, LoggerContext>> buildLoggerContext(Environment environment, ResourceLoader resourceLoader) {
        String logFile = environment.getProperty("logging.config", "classpath:/log4j2.xml");
        LOGGER.info("Located logging configuration reference in the environment as [{}]", (Object)logFile);
        if (ResourceUtils.doesResourceExist((String)logFile, (ResourceLoader)resourceLoader)) {
            Resource logConfigurationFile = resourceLoader.getResource(logFile);
            LOGGER.trace("Loaded logging configuration resource [{}]. Initializing logger context...", (Object)logConfigurationFile);
            LoggerContext loggerContext = (LoggerContext)FunctionUtils.doUnchecked(() -> Configurator.initialize((String)"CAS", null, (URI)logConfigurationFile.getURI()));
            LOGGER.trace("Installing log configuration listener to detect changes and update");
            loggerContext.getConfiguration().addListener(reconfigurable -> loggerContext.updateLoggers(reconfigurable.reconfigure()));
            return Optional.of(Pair.of((Object)logConfigurationFile, (Object)loggerContext));
        }
        LOGGER.warn("Logging configuration cannot be found in the environment settings");
        return Optional.empty();
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        Optional<Pair<Resource, LoggerContext>> pair = LoggingConfigurationEndpoint.buildLoggerContext(this.environment, this.resourceLoader);
        pair.ifPresent(it -> {
            this.logConfigurationFile = (Resource)it.getKey();
            this.loggerContext = (LoggerContext)it.getValue();
        });
    }

    @ReadOperation
    @Operation(summary="Get logging configuration report")
    public Map<String, Object> configuration() {
        HashSet configuredLoggers = new HashSet();
        this.getLoggerConfigurations().forEach(config -> {
            HashMap<String, Object> loggerMap = new HashMap<String, Object>();
            loggerMap.put("name", StringUtils.defaultIfBlank((CharSequence)config.getName(), (CharSequence)LOGGER_NAME_ROOT));
            loggerMap.put("state", config.getState());
            if (config.getPropertyList() != null) {
                loggerMap.put("properties", config.getPropertyList());
            }
            loggerMap.put("additive", config.isAdditive());
            loggerMap.put("level", config.getLevel().name());
            HashSet appenders = new HashSet();
            config.getAppenders().keySet().stream().map(key -> (Appender)config.getAppenders().get(key)).forEach(appender -> {
                ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
                builder.append("name", (Object)appender.getName());
                builder.append("state", (Object)appender.getState());
                builder.append("layoutFormat", (Object)appender.getLayout().getContentFormat());
                builder.append("layoutContentType", (Object)appender.getLayout().getContentType());
                if (appender instanceof FileAppender) {
                    builder.append(FILE_PARAM, (Object)((FileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RandomAccessFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RandomAccessFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RollingFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)((RollingFileAppender)appender).getFilePattern());
                }
                if (appender instanceof MemoryMappedFileAppender) {
                    builder.append(FILE_PARAM, (Object)((MemoryMappedFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingRandomAccessFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RollingRandomAccessFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)((RollingRandomAccessFileAppender)appender).getFilePattern());
                }
                appenders.add(builder.build());
            });
            loggerMap.put("appenders", appenders);
            configuredLoggers.add(loggerMap);
        });
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("loggers", configuredLoggers);
        Map<String, Logger> loggers = this.getActiveLoggersInFactory();
        responseMap.put("activeLoggers", loggers.values());
        return responseMap;
    }

    @WriteOperation
    @Operation(summary="Update logger level for a logger name", parameters={@Parameter(name="loggerName", required=true), @Parameter(name="loggerLevel", required=true), @Parameter(name="additive")})
    public void updateLoggerLevel(@Selector String loggerName, String loggerLevel, boolean additive) {
        Set<LoggerConfig> loggerConfigs = this.getLoggerConfigurations();
        loggerConfigs.stream().filter(cfg -> cfg.getName().equals(loggerName)).forEachOrdered(cfg -> {
            cfg.setLevel(Level.getLevel((String)loggerLevel));
            cfg.setAdditive(additive);
        });
        this.loggerContext.updateLoggers();
    }

    private Map<String, Logger> getActiveLoggersInFactory() {
        Log4jLoggerFactory factory = (Log4jLoggerFactory)LoggingConfigurationEndpoint.getCasLoggerFactoryInstance();
        if (factory != null) {
            return factory.getLoggersInContext((org.apache.logging.log4j.spi.LoggerContext)this.loggerContext);
        }
        return new HashMap<String, Logger>(0);
    }

    private Set<LoggerConfig> getLoggerConfigurations() {
        Configuration configuration = this.loggerContext.getConfiguration();
        return new HashSet<LoggerConfig>(configuration.getLoggers().values());
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    @Generated
    public Resource getLogConfigurationFile() {
        return this.logConfigurationFile;
    }
}

