/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.entity.topology.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.connection.ConnectionService;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntity;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class DynamicTopologyEntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTopologyEntityFactory.class);
    private static final String SECURITY_ROOT_DIRECTORY = "security.root.directory";

    public static DynamicTopologyEntity fetch(Collection<InetSocketAddress> addresses, String connectionName, Duration connectTimeout, DynamicTopologyEntity.Settings settings, String securityRootDirectory) throws ConnectionException {
        Properties properties = DynamicTopologyEntityFactory.buildProperties(connectionName, connectTimeout, securityRootDirectory);
        Connection connection = ConnectionFactory.connect(addresses, properties);
        try {
            DynamicTopologyEntity entity = DynamicTopologyEntityFactory.fetch(connection, settings);
            return DynamicTopologyEntityFactory.closeable(entity, connection);
        }
        catch (EntityException e) {
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionException(e);
        }
    }

    public static DynamicTopologyEntity fetch(ConnectionService connectionService, List<InetSocketAddress> addresses, String connectionName, Duration connectionTimeout, DynamicTopologyEntity.Settings settings, String securityRootDirectory) throws ConnectionException {
        Properties properties = DynamicTopologyEntityFactory.buildProperties(connectionName, connectionTimeout, securityRootDirectory);
        Connection connection = connectionService.connect(addresses, properties);
        try {
            DynamicTopologyEntity entity = DynamicTopologyEntityFactory.fetch(connection, settings);
            return DynamicTopologyEntityFactory.closeable(entity, connection);
        }
        catch (EntityException e) {
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ConnectionException(e);
        }
    }

    public static DynamicTopologyEntity fetch(Connection connection, DynamicTopologyEntity.Settings settings) throws EntityNotProvidedException, EntityVersionMismatchException, EntityNotFoundException {
        EntityRef ref = connection.getEntityRef(DynamicTopologyEntity.class, 1L, "dynamic-config-topology-entity");
        return ref.fetchEntity(settings);
    }

    private static Properties buildProperties(String connectionName, Duration connectionTimeout, String securityRootDirectory) {
        Properties properties = new Properties();
        properties.setProperty("connection.timeout", String.valueOf(connectionTimeout.toMillis()));
        properties.setProperty("connection.name", connectionName);
        properties.setProperty("connection.type", "terracotta");
        if (securityRootDirectory != null) {
            properties.setProperty(SECURITY_ROOT_DIRECTORY, securityRootDirectory);
        }
        return properties;
    }

    private static DynamicTopologyEntity closeable(final DynamicTopologyEntity entity, final Connection connection) {
        return new DynamicTopologyEntity(){

            @Override
            public void setListener(DynamicTopologyEntity.Listener listener) {
                entity.setListener(listener);
            }

            @Override
            public Cluster getUpcomingCluster() throws TimeoutException, InterruptedException {
                return entity.getUpcomingCluster();
            }

            @Override
            public Cluster getRuntimeCluster() throws TimeoutException, InterruptedException {
                return entity.getRuntimeCluster();
            }

            @Override
            public boolean mustBeRestarted() throws TimeoutException, InterruptedException {
                return entity.mustBeRestarted();
            }

            @Override
            public boolean hasIncompleteChange() throws TimeoutException, InterruptedException {
                return entity.hasIncompleteChange();
            }

            @Override
            public License getLicense() throws TimeoutException, InterruptedException {
                return entity.getLicense();
            }

            @Override
            public Future<Void> releaseEntity() {
                return entity.releaseEntity();
            }

            @Override
            public void close() {
                try {
                    connection.close();
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.warn("Error closing entity connection: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
    }
}

