/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;

public final class InstructionTypeCounter
implements Serializable {
    private static final long serialVersionUID = 115L;
    private int scans = 0;
    private int decompressions = 0;
    private int overlappingDecompressions = 0;
    private int leftMultiplications = 0;
    private int rightMultiplications = 0;
    private int compressedMultiplications = 0;
    private int dictionaryOps = 0;
    private int indexing = 0;
    private boolean isDensifying = false;

    public InstructionTypeCounter() {
    }

    public InstructionTypeCounter(int scans, int decompressions, int overlappingDecompressions, int leftMultiplications, int rightMultiplications, int compressedMultiplications, int dictionaryOps, int indexing, boolean isDensifying) {
        this.scans = scans;
        this.decompressions = decompressions;
        this.overlappingDecompressions = overlappingDecompressions;
        this.leftMultiplications = leftMultiplications;
        this.rightMultiplications = rightMultiplications;
        this.compressedMultiplications = compressedMultiplications;
        this.dictionaryOps = dictionaryOps;
        this.indexing = indexing;
        this.isDensifying = isDensifying;
    }

    public int getScans() {
        return this.scans;
    }

    public void incScans() {
        ++this.scans;
    }

    public void incScans(int c) {
        this.scans += c;
    }

    public int getDecompressions() {
        return this.decompressions;
    }

    public void incDecompressions() {
        ++this.decompressions;
    }

    public void incDecompressions(int c) {
        this.decompressions += c;
    }

    public int getOverlappingDecompressions() {
        return this.overlappingDecompressions;
    }

    public void incOverlappingDecompressions() {
        ++this.overlappingDecompressions;
    }

    public void incOverlappingDecompressions(int c) {
        this.overlappingDecompressions += c;
    }

    public int getLeftMultiplications() {
        return this.leftMultiplications;
    }

    public void incLMM() {
        ++this.leftMultiplications;
    }

    public void incLMM(int c) {
        this.leftMultiplications += c;
    }

    public int getRightMultiplications() {
        return this.rightMultiplications;
    }

    public void incRMM() {
        ++this.rightMultiplications;
    }

    public void incRMM(int c) {
        this.rightMultiplications += c;
    }

    public int getCompressedMultiplications() {
        return this.compressedMultiplications;
    }

    public void incCMM() {
        ++this.compressedMultiplications;
    }

    public void incCMM(int c) {
        this.compressedMultiplications += c;
    }

    public int getDictionaryOps() {
        return this.dictionaryOps;
    }

    public void incDictOps() {
        ++this.dictionaryOps;
    }

    public void incDictOps(int c) {
        this.dictionaryOps += c;
    }

    public int getIndexing() {
        return this.indexing;
    }

    public void incIndexOp() {
        ++this.indexing;
    }

    public void incIndexOp(int c) {
        this.indexing += c;
    }

    public void setDensifying(boolean d) {
        this.isDensifying = d;
    }

    public boolean isDensifying() {
        return this.isDensifying;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scans > 0) {
            sb.append(String.format("Sca:%d;", this.scans));
        }
        if (this.decompressions > 0) {
            sb.append(String.format("DeC:%d;", this.decompressions));
        }
        if (this.overlappingDecompressions > 0) {
            sb.append(String.format("OvD:%d;", this.overlappingDecompressions));
        }
        if (this.leftMultiplications > 0) {
            sb.append(String.format("LMM:%d;", this.leftMultiplications));
        }
        if (this.rightMultiplications > 0) {
            sb.append(String.format("RMM:%d;", this.rightMultiplications));
        }
        if (this.compressedMultiplications > 0) {
            sb.append(String.format("CMM:%d;", this.compressedMultiplications));
        }
        if (this.dictionaryOps > 0) {
            sb.append(String.format("dic:%d;", this.dictionaryOps));
        }
        if (this.indexing > 0) {
            sb.append(String.format("ind:%d;", this.indexing));
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

