/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public abstract class ACLAScheme
implements ICLAScheme {
    protected final IColIndex cols;

    protected ACLAScheme(IColIndex cols) {
        this.cols = cols;
    }

    @Override
    public final AColGroup encode(MatrixBlock data) {
        return this.encode(data, this.cols);
    }

    @Override
    public final AColGroup encode(MatrixBlock data, IColIndex columns) {
        this.validate(data, columns);
        return this.encodeV(data, columns);
    }

    protected abstract AColGroup encodeV(MatrixBlock var1, IColIndex var2);

    @Override
    public final AColGroup encodeT(MatrixBlock data) {
        return this.encodeVT(data, this.cols);
    }

    @Override
    public final AColGroup encodeT(MatrixBlock data, IColIndex columns) {
        this.validateT(data, columns);
        return this.encodeVT(data, columns);
    }

    protected abstract AColGroup encodeVT(MatrixBlock var1, IColIndex var2);

    @Override
    public final ICLAScheme update(MatrixBlock data) {
        return this.updateV(data, this.cols);
    }

    @Override
    public final ICLAScheme update(MatrixBlock data, IColIndex columns) {
        this.validate(data, columns);
        return this.updateV(data, columns);
    }

    protected abstract ICLAScheme updateV(MatrixBlock var1, IColIndex var2);

    @Override
    public final ICLAScheme updateT(MatrixBlock data) {
        return this.updateVT(data, this.cols);
    }

    @Override
    public final ICLAScheme updateT(MatrixBlock data, IColIndex columns) {
        this.validateT(data, columns);
        return this.updateVT(data, columns);
    }

    protected abstract ICLAScheme updateVT(MatrixBlock var1, IColIndex var2);

    @Override
    public final Pair<ICLAScheme, AColGroup> updateAndEncode(MatrixBlock data) {
        return this.updateAndEncode(data, this.cols);
    }

    @Override
    public final Pair<ICLAScheme, AColGroup> updateAndEncodeT(MatrixBlock data) {
        return this.updateAndEncodeT(data, this.cols);
    }

    @Override
    public final Pair<ICLAScheme, AColGroup> updateAndEncode(MatrixBlock data, IColIndex columns) {
        this.validate(data, columns);
        try {
            return this.tryUpdateAndEncode(data, columns);
        }
        catch (Exception e) {
            return this.fallBackUpdateAndEncode(data, columns);
        }
    }

    @Override
    public final Pair<ICLAScheme, AColGroup> updateAndEncodeT(MatrixBlock data, IColIndex columns) {
        this.validateT(data, columns);
        try {
            return this.tryUpdateAndEncodeT(data, columns);
        }
        catch (Exception e) {
            return this.fallBackUpdateAndEncodeT(data, columns);
        }
    }

    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncode(MatrixBlock data, IColIndex columns) {
        return this.fallBackUpdateAndEncode(data, columns);
    }

    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncodeT(MatrixBlock data, IColIndex columns) {
        return this.fallBackUpdateAndEncodeT(data, columns);
    }

    private final Pair<ICLAScheme, AColGroup> fallBackUpdateAndEncode(MatrixBlock data, IColIndex columns) {
        ICLAScheme s = this.update(data, columns);
        AColGroup g = s.encode(data, columns);
        return new Pair<ICLAScheme, AColGroup>(s, g);
    }

    private final Pair<ICLAScheme, AColGroup> fallBackUpdateAndEncodeT(MatrixBlock data, IColIndex columns) {
        ICLAScheme s = this.updateT(data, columns);
        AColGroup g = s.encodeT(data, columns);
        return new Pair<ICLAScheme, AColGroup>(s, g);
    }

    private final void validate(MatrixBlock data, IColIndex columns) throws IllegalArgumentException {
        if (columns.size() != this.cols.size()) {
            throw new IllegalArgumentException("Invalid number of columns to encode expected: " + this.cols.size() + " but got: " + columns.size());
        }
        int nCol = data.getNumColumns();
        if (nCol < this.cols.get(this.cols.size() - 1)) {
            throw new IllegalArgumentException("Invalid columns to encode with max col:" + nCol + " list of columns: " + columns);
        }
    }

    private final void validateT(MatrixBlock data, IColIndex columns) throws IllegalArgumentException {
        if (columns.size() != this.cols.size()) {
            throw new IllegalArgumentException("Invalid number of columns to encode expected: " + this.cols.size() + " but got: " + columns.size());
        }
        int nRow = data.getNumRows();
        if (nRow < this.cols.get(this.cols.size() - 1)) {
            throw new IllegalArgumentException("Invalid columns to encode with max col:" + nRow + " list of columns: " + columns);
        }
    }

    @Override
    public abstract ACLAScheme clone();
}

