/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.grouper;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.mapreduce.grouper.SplitContainer;

@InterfaceAudience.Private
public class GroupedSplitContainer {
    private final List<SplitContainer> wrappedSplits;
    private final String wrappedInputFormatName;
    private final String[] locations;
    private final String rack;
    long length = 0L;

    public GroupedSplitContainer(int numSplits, String wrappedInputFormatName, String[] locations, String rack) {
        this.wrappedSplits = Lists.newArrayListWithCapacity((int)numSplits);
        this.wrappedInputFormatName = wrappedInputFormatName;
        this.locations = locations;
        this.rack = rack;
    }

    public void addSplit(SplitContainer splitContainer) {
        this.wrappedSplits.add(splitContainer);
        try {
            this.length += splitContainer.getLength();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public long getLength() {
        return this.length;
    }

    public String getWrappedInputFormatName() {
        return this.wrappedInputFormatName;
    }

    public List<SplitContainer> getWrappedSplitContainers() {
        return this.wrappedSplits;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public String getRack() {
        return this.rack;
    }
}

