/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.runtime.api.TaskContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TaskInputOutputContextImpl<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskAttemptContextImpl
implements TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private RecordWriter<KEYOUT, VALUEOUT> output;
    private OutputCommitter committer;

    public TaskInputOutputContextImpl(Configuration conf, TaskAttemptID taskid, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, TaskContext context, Reporter reporter) {
        super(conf, taskid, context.getCounters(), reporter);
        this.output = output;
        this.committer = committer;
    }

    public abstract boolean nextKeyValue() throws IOException, InterruptedException;

    public abstract KEYIN getCurrentKey() throws IOException, InterruptedException;

    public abstract VALUEIN getCurrentValue() throws IOException, InterruptedException;

    public void write(KEYOUT key, VALUEOUT value) throws IOException, InterruptedException {
        this.output.write(key, value);
    }

    public OutputCommitter getOutputCommitter() {
        return this.committer;
    }
}

