/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.openjpa.lib.conf.Configuration;

public class ClassLoaderProxyService {
    private final ProxiesClassLoader loader;

    public ClassLoaderProxyService(Configuration config, ClassLoader parentLoader) {
        this.loader = parentLoader instanceof ProxiesClassLoader ? (ProxiesClassLoader)parentLoader : new ProxiesClassLoader(parentLoader, false);
    }

    protected ClassLoaderProxyService(ProxiesClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getProxyClassLoader(Class<?> forClass) {
        return this.loader;
    }

    public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
        return this.loader.getOrRegister(name, bytecode, proxiedClass.getPackage(), proxiedClass.getProtectionDomain());
    }

    public <T> T newInstance(Class<? extends T> proxyClass) {
        try {
            return proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create a new Proxy instance of " + proxyClass.getName(), e);
        }
    }

    private static class ProxiesClassLoader
    extends ClassLoader {
        private final boolean skipPackages;
        private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();

        private ProxiesClassLoader(ClassLoader parentLoader, boolean skipPackages) {
            super(parentLoader);
            this.skipPackages = skipPackages;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz = (Class)this.classes.get(name);
            if (clazz == null) {
                return this.getParent().loadClass(name);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> getOrRegister(String proxyClassName, byte[] proxyBytes, Package pck, ProtectionDomain protectionDomain) {
            String key = proxyClassName.replace('/', '.');
            Class<?> existing = (Class<?>)this.classes.get(key);
            if (existing == null) {
                ProxiesClassLoader proxiesClassLoader = this;
                synchronized (proxiesClassLoader) {
                    existing = (Class)this.classes.get(key);
                    if (existing == null) {
                        if (!this.skipPackages) {
                            this.definePackageFor(pck, protectionDomain);
                        }
                        existing = super.defineClass(proxyClassName, proxyBytes, 0, proxyBytes.length);
                        this.resolveClass(existing);
                        this.classes.put(key, existing);
                    }
                }
                try {
                    Class.forName(existing.getName(), true, existing.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return existing;
        }

        private void definePackageFor(Package model, ProtectionDomain protectionDomain) {
            if (model == null) {
                return;
            }
            if (this.getPackage(model.getName()) == null) {
                if (model.isSealed() && protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), protectionDomain.getCodeSource().getLocation());
                } else {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), null);
                }
            }
        }
    }
}

