/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.AbstractEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.slf4j.Logger;

public class ChainingEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    @Nonnull
    private final List<EncryptedKeyResolver> resolvers;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingEncryptedKeyResolver.class);

    public ChainingEncryptedKeyResolver(@Nonnull @ParameterName(name="encKeyResolvers") List<EncryptedKeyResolver> encKeyResolvers) {
        this.resolvers = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(encKeyResolvers, (String)"List of EncryptedKeyResolvers cannot be null")));
    }

    @Deprecated
    public ChainingEncryptedKeyResolver(@Nonnull @ParameterName(name="encKeyResolvers") List<EncryptedKeyResolver> encKeyResolvers, @Nullable @ParameterName(name="recipients") Set<String> recipients) {
        super(recipients);
        this.resolvers = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(encKeyResolvers, (String)"List of EncryptedKeyResolvers cannot be null")));
    }

    @Deprecated
    public ChainingEncryptedKeyResolver(@Nonnull @ParameterName(name="encKeyResolvers") List<EncryptedKeyResolver> encKeyResolvers, @Nullable @ParameterName(name="recipient") String recipient) {
        this(encKeyResolvers, recipient != null ? CollectionSupport.singleton((Object)recipient) : null);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<EncryptedKeyResolver> getResolverChain() {
        return this.resolvers;
    }

    @Override
    @Nonnull
    public Iterable<EncryptedKey> resolve(@Nonnull EncryptedData encryptedData, @Nullable Set<String> recipients) {
        if (this.resolvers.isEmpty()) {
            this.log.warn("Chaining encrypted key resolver resolution was attempted with an empty resolver chain");
            throw new IllegalStateException("The resolver chain is empty");
        }
        return new ChainingIterable(this, encryptedData, recipients);
    }

    public class ChainingIterable
    implements Iterable<EncryptedKey> {
        @Nonnull
        private final ChainingEncryptedKeyResolver parent;
        @Nonnull
        private final EncryptedData encryptedData;
        @Nullable
        private final Set<String> recipients;

        public ChainingIterable(@Nonnull ChainingEncryptedKeyResolver resolver, @Nullable EncryptedData encData, Set<String> recipientIDs) {
            this.parent = resolver;
            this.encryptedData = encData;
            this.recipients = recipientIDs;
        }

        @Override
        @Nonnull
        public Iterator<EncryptedKey> iterator() {
            return new ChainingIterator(this.parent, this.encryptedData, this.recipients);
        }
    }

    public class ChainingIterator
    implements Iterator<EncryptedKey> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(ChainingIterator.class);
        @Nonnull
        private final ChainingEncryptedKeyResolver parent;
        @Nonnull
        private final EncryptedData encryptedData;
        @Nonnull
        @Unmodifiable
        @NotLive
        private final Set<String> validRecipients;
        @Nonnull
        private final Iterator<EncryptedKeyResolver> resolverIterator;
        private Iterator<EncryptedKey> keyIterator;
        private EncryptedKeyResolver currentResolver;
        @Nullable
        private EncryptedKey nextKey;

        public ChainingIterator(@Nonnull ChainingEncryptedKeyResolver resolver, @Nullable EncryptedData encData, Set<String> recipientIDs) {
            this.parent = resolver;
            this.encryptedData = encData;
            this.validRecipients = ChainingEncryptedKeyResolver.this.getEffectiveRecipients(recipientIDs);
            this.resolverIterator = this.parent.getResolverChain().iterator();
            this.keyIterator = this.getNextKeyIterator();
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextKey != null) {
                return true;
            }
            this.nextKey = this.getNextKey();
            return this.nextKey != null;
        }

        @Override
        public EncryptedKey next() {
            if (this.nextKey != null) {
                EncryptedKey tempKey = this.nextKey;
                this.nextKey = null;
                return tempKey;
            }
            EncryptedKey tempKey = this.getNextKey();
            if (tempKey != null) {
                return tempKey;
            }
            throw new NoSuchElementException("No more EncryptedKey elements are available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported by this iterator");
        }

        @Nullable
        private Iterator<EncryptedKey> getNextKeyIterator() {
            if (this.resolverIterator.hasNext()) {
                this.currentResolver = this.resolverIterator.next();
                this.log.debug("Getting key iterator from next resolver: {}", (Object)this.currentResolver.getClass().toString());
                return this.currentResolver.resolve(this.encryptedData).iterator();
            }
            this.log.debug("No more resolvers available in the resolver chain");
            this.currentResolver = null;
            return null;
        }

        @Nullable
        private EncryptedKey getNextKey() {
            EncryptedKey tempKey;
            if (this.keyIterator != null) {
                while (this.keyIterator.hasNext()) {
                    tempKey = this.keyIterator.next();
                    if (!this.parent.matchRecipient(tempKey.getRecipient(), this.validRecipients)) continue;
                    this.log.debug("Found matching encrypted key: {}", (Object)tempKey.toString());
                    return tempKey;
                }
            }
            this.keyIterator = this.getNextKeyIterator();
            while (this.keyIterator != null) {
                while (this.keyIterator.hasNext()) {
                    tempKey = this.keyIterator.next();
                    if (!this.parent.matchRecipient(tempKey.getRecipient(), this.validRecipients)) continue;
                    this.log.debug("Found matching encrypted key: {}", (Object)tempKey.toString());
                    return tempKey;
                }
                this.keyIterator = this.getNextKeyIterator();
            }
            return null;
        }
    }
}

