/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.server.session.AbstractSession;
import wiremock.org.eclipse.jetty.server.session.AbstractSessionManager;
import wiremock.org.eclipse.jetty.server.session.HashedSession;
import wiremock.org.eclipse.jetty.server.session.SessionHandler;
import wiremock.org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import wiremock.org.eclipse.jetty.util.thread.Scheduler;

public class HashSessionManager
extends AbstractSessionManager {
    static final Logger LOG = SessionHandler.LOG;
    protected final ConcurrentMap<String, HashedSession> _sessions = new ConcurrentHashMap<String, HashedSession>();
    private Scheduler _timer;
    private Scheduler.Task _task;
    long _scavengePeriodMs = 30000L;
    long _savePeriodMs = 0L;
    long _idleSavePeriodMs = 0L;
    private Scheduler.Task _saveTask;
    File _storeDir;
    private boolean _lazyLoad = false;
    private volatile boolean _sessionsLoaded = false;
    private boolean _deleteUnrestorableSessions = false;

    @Override
    public void doStart() throws Exception {
        ContextHandler.Context context;
        this._timer = this.getSessionHandler().getServer().getBean(Scheduler.class);
        if (this._timer == null && (context = ContextHandler.getCurrentContext()) != null) {
            this._timer = (Scheduler)context.getAttribute("wiremock.org.eclipse.jetty.server.session.timer");
        }
        if (this._timer == null) {
            this._timer = new ScheduledExecutorScheduler(this.toString() + "Timer", true);
            this.addBean((Object)this._timer, true);
        } else {
            this.addBean((Object)this._timer, false);
        }
        super.doStart();
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdirs();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            this._saveTask = null;
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
        super.doStop();
        this._sessions.clear();
    }

    public int getScavengePeriod() {
        return (int)(this._scavengePeriodMs / 1000L);
    }

    @Override
    public int getSessions() {
        int sessions = super.getSessions();
        if (LOG.isDebugEnabled() && this._sessions.size() != sessions) {
            LOG.warn("sessions: " + this._sessions.size() + "!=" + sessions, new Object[0]);
        }
        return sessions;
    }

    public int getIdleSavePeriod() {
        if (this._idleSavePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._idleSavePeriodMs / 1000L);
    }

    public void setIdleSavePeriod(int seconds) {
        this._idleSavePeriodMs = (long)seconds * 1000L;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        super.setMaxInactiveInterval(seconds);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > (long)this._dftMaxIdleSecs * 1000L) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int seconds) {
        long period = (long)seconds * 1000L;
        if (period < 0L) {
            period = 0L;
        }
        this._savePeriodMs = period;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                this._saveTask = null;
                if (this._savePeriodMs > 0L && this._storeDir != null) {
                    this._saveTask = this._timer.schedule(new Saver(), this._savePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._savePeriodMs / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        long old_period = this._scavengePeriodMs;
        long period = (long)seconds * 1000L;
        if (period > 60000L) {
            period = 60000L;
        }
        if (period < 1000L) {
            period = 1000L;
        }
        this._scavengePeriodMs = period;
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._timer != null && (period != old_period || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                    this._task = null;
                }
                this._task = this._timer.schedule(new Scavenger(), this._scavengePeriodMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            __log.debug("Scavenging sessions at {}", now);
            for (HashedSession session : this._sessions.values()) {
                long idleTime = (long)session.getMaxInactiveInterval() * 1000L;
                if (idleTime > 0L && session.getAccessed() + idleTime < now) {
                    try {
                        session.timeout();
                    }
                    catch (Exception e) {
                        __log.warn("Problem scavenging sessions", e);
                    }
                    continue;
                }
                if (this._idleSavePeriodMs <= 0L || session.getAccessed() + this._idleSavePeriodMs >= now) continue;
                try {
                    session.idle();
                }
                catch (Exception e) {
                    __log.warn("Problem idling session " + session.getId(), e);
                }
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    @Override
    protected void addSession(AbstractSession session) {
        if (this.isRunning()) {
            this._sessions.put(session.getClusterId(), (HashedSession)session);
        }
    }

    @Override
    public AbstractSession getSession(String idInCluster) {
        ConcurrentMap<String, HashedSession> sessions;
        if (this._lazyLoad && !this._sessionsLoaded) {
            try {
                this.restoreSessions();
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
        if ((sessions = this._sessions) == null) {
            return null;
        }
        HashedSession session = (HashedSession)sessions.get(idInCluster);
        if (session == null && this._lazyLoad) {
            session = this.restoreSession(idInCluster);
        }
        if (session == null) {
            return null;
        }
        if (this._idleSavePeriodMs != 0L) {
            session.deIdle();
        }
        return session;
    }

    @Override
    protected void shutdownSessions() throws Exception {
        ArrayList sessions = new ArrayList(this._sessions.values());
        int loop = 100;
        while (sessions.size() > 0 && loop-- > 0) {
            if (this.isStopping() && this._storeDir != null && this._storeDir.exists() && this._storeDir.canWrite()) {
                for (HashedSession session : sessions) {
                    session.save(false);
                    this._sessions.remove(session.getClusterId());
                }
            } else {
                for (HashedSession session : sessions) {
                    session.invalidate();
                }
            }
            sessions = new ArrayList(this._sessions.values());
        }
    }

    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        try {
            ConcurrentMap<String, HashedSession> sessions = this._sessions;
            if (sessions == null) {
                return;
            }
            HashedSession session = (HashedSession)sessions.remove(oldClusterId);
            if (session == null) {
                return;
            }
            session.remove();
            session.setClusterId(newClusterId);
            session.setNodeId(newNodeId);
            session.save();
            sessions.put(newClusterId, session);
            super.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest request) {
        return new HashedSession(this, request);
    }

    protected AbstractSession newSession(long created, long accessed, String clusterId) {
        return new HashedSession(this, created, accessed, clusterId);
    }

    @Override
    protected boolean removeSession(String clusterId) {
        return this._sessions.remove(clusterId) != null;
    }

    public void setStoreDirectory(File dir) throws IOException {
        this._storeDir = dir.getCanonicalFile();
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this._lazyLoad = lazyLoad;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public boolean isDeleteUnrestorableSessions() {
        return this._deleteUnrestorableSessions;
    }

    public void setDeleteUnrestorableSessions(boolean deleteUnrestorableSessions) {
        this._deleteUnrestorableSessions = deleteUnrestorableSessions;
    }

    public void restoreSessions() throws Exception {
        this._sessionsLoaded = true;
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            LOG.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath(), new Object[0]);
            return;
        }
        String[] files = this._storeDir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            this.restoreSession(files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized HashedSession restoreSession(String idInCuster) {
        File file = new File(this._storeDir, idInCuster);
        Exception error = null;
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not loading: {}", file);
            }
            return null;
        }
        try {
            HashedSession hashedSession;
            Throwable throwable;
            FileInputStream in;
            block23: {
                block24: {
                    in = new FileInputStream(file);
                    throwable = null;
                    HashedSession session = this.restoreSession(in, null);
                    this.addSession(session, false);
                    session.didActivate();
                    hashedSession = session;
                    if (in == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block23;
                }
                in.close();
            }
            return hashedSession;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    error = e;
                }
            }
        }
        finally {
            if (error != null) {
                if (this.isDeleteUnrestorableSessions() && file.exists() && file.getParentFile().equals(this._storeDir)) {
                    file.delete();
                    LOG.warn("Deleting file for unrestorable session " + idInCuster, error);
                } else {
                    __log.warn("Problem restoring session " + idInCuster, error);
                }
            } else {
                file.delete();
            }
        }
        return null;
    }

    public void saveSessions(boolean reactivate) throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            LOG.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable", new Object[0]);
            return;
        }
        for (HashedSession session : this._sessions.values()) {
            session.save(reactivate);
        }
    }

    public HashedSession restoreSession(InputStream is, HashedSession session) throws Exception {
        DataInputStream di = new DataInputStream(is);
        String clusterId = di.readUTF();
        di.readUTF();
        long created = di.readLong();
        long accessed = di.readLong();
        int requests = di.readInt();
        if (session == null) {
            session = (HashedSession)this.newSession(created, accessed, clusterId);
        }
        session.setRequests(requests);
        int size = di.readInt();
        this.restoreSessionAttributes(di, size, session);
        try {
            int maxIdle = di.readInt();
            session.setMaxInactiveInterval(maxIdle);
        }
        catch (IOException e) {
            LOG.debug("No maxInactiveInterval persisted for session " + clusterId, new Object[0]);
            LOG.ignore(e);
        }
        return session;
    }

    private void restoreSessionAttributes(InputStream is, int size, HashedSession session) throws Exception {
        if (size > 0) {
            ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);
            for (int i = 0; i < size; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                session.setAttribute(key, value);
            }
        }
    }

    protected class Saver
    implements Runnable {
        protected Saver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashSessionManager.this.saveSessions(true);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
            finally {
                if (HashSessionManager.this._timer != null && HashSessionManager.this._timer.isRunning()) {
                    HashSessionManager.this._saveTask = HashSessionManager.this._timer.schedule(this, HashSessionManager.this._savePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    protected class Scavenger
    implements Runnable {
        protected Scavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashSessionManager.this.scavenge();
            }
            finally {
                if (HashSessionManager.this._timer != null && HashSessionManager.this._timer.isRunning()) {
                    HashSessionManager.this._task = HashSessionManager.this._timer.schedule(this, HashSessionManager.this._scavengePeriodMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

