/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class StartsWithCondition
extends TypeSentiveCondition {
    public StartsWithCondition(ITypeExpression type) {
        super(type);
    }

    public StartsWithCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (!this.isWorkingOnList()) {
            Type t = this.type.getType(context, stream);
            boolean result = this.check(annotation, t, stream);
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        for (Type t : types) {
            if (!(result |= this.check(annotation, t, stream))) continue;
            return new EvaluatedCondition(this, result);
        }
        result = false;
        return new EvaluatedCondition(this, result);
    }

    private boolean check(AnnotationFS annotation, Type t, RutaStream stream) {
        if (annotation == null || t == null) {
            return false;
        }
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        if (beginAnchor != null) {
            return beginAnchor.beginsWith(t);
        }
        return false;
    }
}

