/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class RpcResponse
extends Message {
    private long requestId;
    private StatusCode statusCode;
    private String retMessage;

    public RpcResponse(long requestId, StatusCode statusCode) {
        this(requestId, statusCode, null);
    }

    public RpcResponse(long requestId, StatusCode statusCode, String retMessage) {
        this.requestId = requestId;
        this.statusCode = statusCode;
        this.retMessage = retMessage;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getRetMessage() {
        return this.retMessage;
    }

    public String toString() {
        return "RpcResponse{requestId=" + this.requestId + ", statusCode=" + (Object)((Object)this.statusCode) + ", retMessage='" + this.retMessage + '\'' + '}';
    }

    @Override
    public int encodedLength() {
        return 12 + ByteBufUtils.encodedLength(this.retMessage);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt(this.statusCode.ordinal());
        ByteBufUtils.writeLengthAndString(buf, this.retMessage);
    }

    public static RpcResponse decode(ByteBuf buf) {
        long requestId = buf.readLong();
        StatusCode statusCode = StatusCode.fromCode(buf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(buf);
        return new RpcResponse(requestId, statusCode, retMessage);
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RPC_RESPONSE;
    }
}

