/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.impl.ShuffleReadClientImpl;
import org.apache.uniffle.client.impl.ShuffleWriteClientImpl;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.IdHelper;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;

public class ShuffleClientFactory {
    private static final ShuffleClientFactory INSTANCE = new ShuffleClientFactory();

    private ShuffleClientFactory() {
    }

    public static ShuffleClientFactory getInstance() {
        return INSTANCE;
    }

    public ShuffleWriteClient createShuffleWriteClient(WriteClientBuilder builder) {
        if (builder.isReplicaSkipEnabled() && builder.getReplica() > builder.getReplicaWrite()) {
            builder.retryMax(builder.getRetryMax() / 2);
        }
        return builder.build();
    }

    public ShuffleReadClient createShuffleReadClient(ReadClientBuilder builder) {
        return builder.build();
    }

    public static WriteClientBuilder newWriteBuilder() {
        return new WriteClientBuilder();
    }

    public static ReadClientBuilder newReadBuilder() {
        return new ReadClientBuilder();
    }

    public static class ReadClientBuilder {
        private String appId;
        private int shuffleId;
        private int partitionId;
        private String basePath;
        private int partitionNumPerRange;
        private int partitionNum;
        private Roaring64NavigableMap blockIdBitmap;
        private Roaring64NavigableMap taskIdBitmap;
        private List<ShuffleServerInfo> shuffleServerInfoList;
        private Configuration hadoopConf;
        private IdHelper idHelper;
        private ShuffleDataDistributionType shuffleDataDistributionType;
        private boolean expectedTaskIdsBitmapFilterEnable;
        private RssConf rssConf;
        private boolean offHeapEnable;
        private String storageType;
        private int indexReadLimit;
        private long readBufferSize;
        private ClientType clientType;
        private int retryMax;
        private long retryIntervalMax;

        public ReadClientBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public ReadClientBuilder shuffleId(int shuffleId) {
            this.shuffleId = shuffleId;
            return this;
        }

        public ReadClientBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public ReadClientBuilder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public ReadClientBuilder partitionNumPerRange(int partitionNumPerRange) {
            this.partitionNumPerRange = partitionNumPerRange;
            return this;
        }

        public ReadClientBuilder partitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        public ReadClientBuilder blockIdBitmap(Roaring64NavigableMap blockIdBitmap) {
            this.blockIdBitmap = blockIdBitmap;
            return this;
        }

        public ReadClientBuilder taskIdBitmap(Roaring64NavigableMap taskIdBitmap) {
            this.taskIdBitmap = taskIdBitmap;
            return this;
        }

        public ReadClientBuilder shuffleServerInfoList(List<ShuffleServerInfo> shuffleServerInfoList) {
            this.shuffleServerInfoList = shuffleServerInfoList;
            return this;
        }

        public ReadClientBuilder hadoopConf(Configuration hadoopConf) {
            this.hadoopConf = hadoopConf;
            return this;
        }

        public ReadClientBuilder idHelper(IdHelper idHelper) {
            this.idHelper = idHelper;
            return this;
        }

        public ReadClientBuilder shuffleDataDistributionType(ShuffleDataDistributionType shuffleDataDistributionType) {
            this.shuffleDataDistributionType = shuffleDataDistributionType;
            return this;
        }

        public ReadClientBuilder expectedTaskIdsBitmapFilterEnable(boolean expectedTaskIdsBitmapFilterEnable) {
            this.expectedTaskIdsBitmapFilterEnable = expectedTaskIdsBitmapFilterEnable;
            return this;
        }

        public ReadClientBuilder rssConf(RssConf rssConf) {
            this.rssConf = rssConf;
            return this;
        }

        public ReadClientBuilder offHeapEnable(boolean offHeapEnable) {
            this.offHeapEnable = offHeapEnable;
            return this;
        }

        public ReadClientBuilder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public ReadClientBuilder indexReadLimit(int indexReadLimit) {
            this.indexReadLimit = indexReadLimit;
            return this;
        }

        public ReadClientBuilder readBufferSize(long readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public ReadClientBuilder clientType(ClientType clientType) {
            this.clientType = clientType;
            return this;
        }

        public ReadClientBuilder retryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        public ReadClientBuilder retryIntervalMax(long retryIntervalMax) {
            this.retryIntervalMax = retryIntervalMax;
            return this;
        }

        public String getAppId() {
            return this.appId;
        }

        public int getShuffleId() {
            return this.shuffleId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public int getPartitionNumPerRange() {
            return this.partitionNumPerRange;
        }

        public int getPartitionNum() {
            return this.partitionNum;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public Roaring64NavigableMap getBlockIdBitmap() {
            return this.blockIdBitmap;
        }

        public Roaring64NavigableMap getTaskIdBitmap() {
            return this.taskIdBitmap;
        }

        public List<ShuffleServerInfo> getShuffleServerInfoList() {
            return this.shuffleServerInfoList;
        }

        public Configuration getHadoopConf() {
            return this.hadoopConf;
        }

        public IdHelper getIdHelper() {
            return this.idHelper;
        }

        public ShuffleDataDistributionType getShuffleDataDistributionType() {
            return this.shuffleDataDistributionType;
        }

        public boolean isExpectedTaskIdsBitmapFilterEnable() {
            return this.expectedTaskIdsBitmapFilterEnable;
        }

        public RssConf getRssConf() {
            return this.rssConf;
        }

        public boolean isOffHeapEnable() {
            return this.offHeapEnable;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public int getIndexReadLimit() {
            return this.indexReadLimit;
        }

        public long getReadBufferSize() {
            return this.readBufferSize;
        }

        public ClientType getClientType() {
            return this.clientType;
        }

        public int getRetryMax() {
            return this.retryMax;
        }

        public long getRetryIntervalMax() {
            return this.retryIntervalMax;
        }

        public ShuffleReadClientImpl build() {
            return new ShuffleReadClientImpl(this);
        }
    }

    public static class WriteClientBuilder {
        private String clientType;
        private int retryMax;
        private long retryIntervalMax;
        private int heartBeatThreadNum;
        private int replica;
        private int replicaWrite;
        private int replicaRead;
        private boolean replicaSkipEnabled;
        private int dataTransferPoolSize;
        private int dataCommitPoolSize;
        private int unregisterThreadPoolSize;
        private int unregisterRequestTimeSec;
        private RssConf rssConf;

        private WriteClientBuilder() {
        }

        public String getClientType() {
            return this.clientType;
        }

        public int getRetryMax() {
            return this.retryMax;
        }

        public long getRetryIntervalMax() {
            return this.retryIntervalMax;
        }

        public int getHeartBeatThreadNum() {
            return this.heartBeatThreadNum;
        }

        public int getReplica() {
            return this.replica;
        }

        public int getReplicaWrite() {
            return this.replicaWrite;
        }

        public int getReplicaRead() {
            return this.replicaRead;
        }

        public boolean isReplicaSkipEnabled() {
            return this.replicaSkipEnabled;
        }

        public int getDataTransferPoolSize() {
            return this.dataTransferPoolSize;
        }

        public int getDataCommitPoolSize() {
            return this.dataCommitPoolSize;
        }

        public int getUnregisterThreadPoolSize() {
            return this.unregisterThreadPoolSize;
        }

        public int getUnregisterRequestTimeSec() {
            return this.unregisterRequestTimeSec;
        }

        public RssConf getRssConf() {
            return this.rssConf;
        }

        public WriteClientBuilder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public WriteClientBuilder retryMax(int retryMax) {
            this.retryMax = retryMax;
            return this;
        }

        public WriteClientBuilder retryIntervalMax(long retryIntervalMax) {
            this.retryIntervalMax = retryIntervalMax;
            return this;
        }

        public WriteClientBuilder heartBeatThreadNum(int heartBeatThreadNum) {
            this.heartBeatThreadNum = heartBeatThreadNum;
            return this;
        }

        public WriteClientBuilder replica(int replica) {
            this.replica = replica;
            return this;
        }

        public WriteClientBuilder replicaWrite(int replicaWrite) {
            this.replicaWrite = replicaWrite;
            return this;
        }

        public WriteClientBuilder replicaRead(int replicaRead) {
            this.replicaRead = replicaRead;
            return this;
        }

        public WriteClientBuilder replicaSkipEnabled(boolean replicaSkipEnabled) {
            this.replicaSkipEnabled = replicaSkipEnabled;
            return this;
        }

        public WriteClientBuilder dataTransferPoolSize(int dataTransferPoolSize) {
            this.dataTransferPoolSize = dataTransferPoolSize;
            return this;
        }

        public WriteClientBuilder dataCommitPoolSize(int dataCommitPoolSize) {
            this.dataCommitPoolSize = dataCommitPoolSize;
            return this;
        }

        public WriteClientBuilder unregisterThreadPoolSize(int unregisterThreadPoolSize) {
            this.unregisterThreadPoolSize = unregisterThreadPoolSize;
            return this;
        }

        public WriteClientBuilder unregisterRequestTimeSec(int unregisterRequestTimeSec) {
            this.unregisterRequestTimeSec = unregisterRequestTimeSec;
            return this;
        }

        public WriteClientBuilder rssConf(RssConf rssConf) {
            this.rssConf = rssConf;
            return this;
        }

        public ShuffleWriteClientImpl build() {
            return new ShuffleWriteClientImpl(this);
        }
    }
}

