/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.handle.BaseMessageHandler;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexRequest;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexResponse;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.GetMemoryShuffleDataResponse;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.netty.protocol.SendShuffleDataRequest;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.guava.collect.Lists;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.buffer.PreAllocatedBufferInfo;
import org.apache.uniffle.server.buffer.ShuffleBufferManager;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerNettyHandler
implements BaseMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerNettyHandler.class);
    private static final int RPC_TIMEOUT = 60000;
    private final ShuffleServer shuffleServer;

    public ShuffleServerNettyHandler(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
    }

    public void receive(TransportClient client, RequestMessage msg) {
        this.shuffleServer.getNettyMetrics().incCounter(msg.getClass().getName());
        if (msg instanceof SendShuffleDataRequest) {
            this.handleSendShuffleDataRequest(client, (SendShuffleDataRequest)msg);
        } else if (msg instanceof GetLocalShuffleDataRequest) {
            this.handleGetLocalShuffleData(client, (GetLocalShuffleDataRequest)msg);
        } else if (msg instanceof GetLocalShuffleIndexRequest) {
            this.handleGetLocalShuffleIndexRequest(client, (GetLocalShuffleIndexRequest)msg);
        } else if (msg instanceof GetMemoryShuffleDataRequest) {
            this.handleGetMemoryShuffleDataRequest(client, (GetMemoryShuffleDataRequest)msg);
        } else {
            throw new RssException("Can not handle message " + msg.type());
        }
        this.shuffleServer.getNettyMetrics().decCounter(msg.getClass().getName());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        LOG.error("exception caught {}", (Object)client.getSocketAddress(), (Object)cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSendShuffleDataRequest(TransportClient client, SendShuffleDataRequest req) {
        RpcResponse rpcResponse;
        int requireSize;
        long transportTime;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        long requireBufferId = req.getRequireId();
        long timestamp = req.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getNettyMetrics().recordTransportTime(SendShuffleDataRequest.class.getName(), transportTime);
        }
        int requireBlocksSize = (requireSize = this.shuffleServer.getShuffleTaskManager().getRequireBufferSize(requireBufferId)) - req.encodedLength() < 0 ? 0 : requireSize - req.encodedLength();
        StatusCode ret = StatusCode.SUCCESS;
        String responseMessage = "OK";
        if (req.getPartitionToBlocks().size() > 0) {
            boolean isPreAllocated;
            ShuffleServerMetrics.counterTotalReceivedDataSize.inc((double)requireBlocksSize);
            ShuffleTaskManager manager = this.shuffleServer.getShuffleTaskManager();
            PreAllocatedBufferInfo info = manager.getAndRemovePreAllocatedBuffer(requireBufferId);
            boolean bl = isPreAllocated = info != null;
            if (!isPreAllocated) {
                req.getPartitionToBlocks().values().stream().flatMap(Collection::stream).forEach(block -> block.getData().release());
                String errorMsg = "Can't find requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "], probably because the pre-allocated buffer has expired. Please increase the expiration time using " + ShuffleServerConf.SERVER_PRE_ALLOCATION_EXPIRED.key() + " in ShuffleServer's configuration";
                LOG.warn(errorMsg);
                RpcResponse rpcResponse2 = new RpcResponse(req.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg);
                client.getChannel().writeAndFlush((Object)rpcResponse2);
                return;
            }
            long start = System.currentTimeMillis();
            ShuffleBufferManager shuffleBufferManager = this.shuffleServer.getShuffleBufferManager();
            shuffleBufferManager.releaseMemory(req.encodedLength(), false, true);
            List<ShufflePartitionedData> shufflePartitionedData = this.toPartitionedData(req);
            long alreadyReleasedSize = 0L;
            boolean hasFailureOccurred = false;
            for (ShufflePartitionedData spd : shufflePartitionedData) {
                String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + spd.getPartitionId() + "]";
                try {
                    if (hasFailureOccurred) continue;
                    ret = manager.cacheShuffleData(appId, shuffleId, isPreAllocated, spd);
                    if (ret != StatusCode.SUCCESS) {
                        String errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ", statusCode=" + ret;
                        LOG.error(errorMsg);
                        responseMessage = errorMsg;
                        hasFailureOccurred = true;
                        continue;
                    }
                    long toReleasedSize = spd.getTotalBlockSize();
                    manager.releasePreAllocatedSize(toReleasedSize);
                    alreadyReleasedSize += toReleasedSize;
                    manager.updateCachedBlockIds(appId, shuffleId, spd.getPartitionId(), spd.getBlockList());
                }
                catch (Exception e) {
                    String errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                    ret = StatusCode.INTERNAL_ERROR;
                    responseMessage = errorMsg;
                    LOG.error(errorMsg);
                    hasFailureOccurred = true;
                }
                finally {
                    if (!hasFailureOccurred) continue;
                    Arrays.stream(spd.getBlockList()).forEach(block -> block.getData().release());
                    shuffleBufferManager.releaseMemory(spd.getTotalBlockSize(), false, false);
                }
            }
            if ((long)requireBlocksSize > alreadyReleasedSize) {
                manager.releasePreAllocatedSize((long)requireBlocksSize - alreadyReleasedSize);
            }
            rpcResponse = new RpcResponse(req.getRequestId(), ret, responseMessage);
            long costTime = System.currentTimeMillis() - start;
            this.shuffleServer.getNettyMetrics().recordProcessTime(SendShuffleDataRequest.class.getName(), costTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache Shuffle Data for appId[" + appId + "], shuffleId[" + shuffleId + "], cost " + costTime + " ms with " + shufflePartitionedData.size() + " blocks and " + requireBlocksSize + " bytes");
            }
        } else {
            rpcResponse = new RpcResponse(req.getRequestId(), StatusCode.INTERNAL_ERROR, "No data in request");
        }
        client.getChannel().writeAndFlush((Object)rpcResponse);
    }

    public void handleGetMemoryShuffleDataRequest(TransportClient client, GetMemoryShuffleDataRequest req) {
        GetMemoryShuffleDataResponse response;
        long transportTime;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        int partitionId = req.getPartitionId();
        long blockId = req.getLastBlockId();
        int readBufferSize = req.getReadBufferSize();
        long timestamp = req.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getNettyMetrics().recordTransportTime(GetMemoryShuffleDataRequest.class.getName(), transportTime);
        }
        long start = System.currentTimeMillis();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(readBufferSize)) {
            ShuffleDataResult shuffleDataResult = null;
            try {
                shuffleDataResult = this.shuffleServer.getShuffleTaskManager().getInMemoryShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, req.getExpectedTaskIdsBitmap());
                NettyManagedBuffer data = NettyManagedBuffer.EMPTY_BUFFER;
                List bufferSegments = Lists.newArrayList();
                if (shuffleDataResult != null) {
                    data = shuffleDataResult.getManagedBuffer();
                    bufferSegments = shuffleDataResult.getBufferSegments();
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.size());
                    ShuffleServerMetrics.counterTotalReadMemoryDataSize.inc((double)data.size());
                }
                GetMemoryShuffleDataResponse response2 = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, bufferSegments, (ManagedBuffer)data);
                ReleaseMemoryAndRecordReadTimeListener listener = new ReleaseMemoryAndRecordReadTimeListener(start, readBufferSize, data.size(), requestInfo, (RequestMessage)req, client);
                client.getChannel().writeAndFlush((Object)response2).addListener((GenericFutureListener)listener);
                return;
            }
            catch (Exception e) {
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(readBufferSize);
                if (shuffleDataResult != null) {
                    shuffleDataResult.release();
                }
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get in memory shuffle data for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get in memory shuffle data";
            LOG.error(msg + " for " + requestInfo);
            response = new GetMemoryShuffleDataResponse(req.getRequestId(), status, msg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
        }
        client.getChannel().writeAndFlush((Object)response);
    }

    public void handleGetLocalShuffleIndexRequest(TransportClient client, GetLocalShuffleIndexRequest req) {
        GetLocalShuffleIndexResponse response;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        int partitionId = req.getPartitionId();
        int partitionNumPerRange = req.getPartitionNumPerRange();
        int partitionNum = req.getPartitionNum();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
        if (storage != null) {
            storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
        }
        long assumedFileSize = this.shuffleServer.getShuffleServerConf().getLong(ShuffleServerConf.SERVER_SHUFFLE_INDEX_SIZE_HINT);
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(assumedFileSize)) {
            ShuffleIndexResult shuffleIndexResult = null;
            try {
                long start = System.currentTimeMillis();
                shuffleIndexResult = this.shuffleServer.getShuffleTaskManager().getShuffleIndex(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum);
                ManagedBuffer data = shuffleIndexResult.getManagedBuffer();
                ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.size());
                ShuffleServerMetrics.counterTotalReadLocalIndexFileSize.inc((double)data.size());
                GetLocalShuffleIndexResponse response2 = new GetLocalShuffleIndexResponse(req.getRequestId(), status, msg, data, shuffleIndexResult.getDataFileLen());
                ReleaseMemoryAndRecordReadTimeListener listener = new ReleaseMemoryAndRecordReadTimeListener(start, assumedFileSize, data.size(), requestInfo, (RequestMessage)req, client);
                client.getChannel().writeAndFlush((Object)response2).addListener((GenericFutureListener)listener);
                return;
            }
            catch (FileNotFoundException indexFileNotFoundException) {
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
                if (shuffleIndexResult != null) {
                    shuffleIndexResult.release();
                }
                LOG.warn("Index file for {} is not found, maybe the data has been flushed to cold storage.", (Object)requestInfo, (Object)indexFileNotFoundException);
                response = new GetLocalShuffleIndexResponse(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
            }
            catch (Exception e) {
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
                if (shuffleIndexResult != null) {
                    shuffleIndexResult.release();
                }
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get shuffle index for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                response = new GetLocalShuffleIndexResponse(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle index";
            LOG.error(msg + " for " + requestInfo);
            response = new GetLocalShuffleIndexResponse(req.getRequestId(), status, msg, Unpooled.EMPTY_BUFFER, 0L);
        }
        client.getChannel().writeAndFlush((Object)response);
    }

    public void handleGetLocalShuffleData(TransportClient client, GetLocalShuffleDataRequest req) {
        GetLocalShuffleDataResponse response;
        long transportTime;
        String appId = req.getAppId();
        int shuffleId = req.getShuffleId();
        int partitionId = req.getPartitionId();
        int partitionNumPerRange = req.getPartitionNumPerRange();
        int partitionNum = req.getPartitionNum();
        long offset = req.getOffset();
        int length = req.getLength();
        long timestamp = req.getTimestamp();
        if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
            this.shuffleServer.getNettyMetrics().recordTransportTime(GetLocalShuffleDataRequest.class.getName(), transportTime);
        }
        String storageType = ((StorageType)this.shuffleServer.getShuffleServerConf().get(RssBaseConf.RSS_STORAGE_TYPE)).name();
        StatusCode status = StatusCode.SUCCESS;
        String msg = "OK";
        String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "], offset[" + offset + "], length[" + length + "]";
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
        if (storage != null) {
            storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
        }
        if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(length)) {
            ShuffleDataResult sdr = null;
            try {
                long start = System.currentTimeMillis();
                sdr = this.shuffleServer.getShuffleTaskManager().getShuffleData(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, storageType, offset, length);
                ShuffleServerMetrics.counterTotalReadDataSize.inc((double)sdr.getDataLength());
                ShuffleServerMetrics.counterTotalReadLocalDataFileSize.inc((double)sdr.getDataLength());
                GetLocalShuffleDataResponse response2 = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, sdr.getManagedBuffer());
                ReleaseMemoryAndRecordReadTimeListener listener = new ReleaseMemoryAndRecordReadTimeListener(start, length, sdr.getDataLength(), requestInfo, (RequestMessage)req, client);
                client.getChannel().writeAndFlush((Object)response2).addListener((GenericFutureListener)listener);
                return;
            }
            catch (Exception e) {
                this.shuffleServer.getShuffleBufferManager().releaseReadMemory(length);
                if (sdr != null) {
                    sdr.release();
                }
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                response = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
            }
        } else {
            status = StatusCode.NO_BUFFER;
            msg = "Can't require memory to get shuffle data";
            LOG.error(msg + " for " + requestInfo);
            response = new GetLocalShuffleDataResponse(req.getRequestId(), status, msg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
        }
        client.getChannel().writeAndFlush((Object)response);
    }

    private List<ShufflePartitionedData> toPartitionedData(SendShuffleDataRequest req) {
        ArrayList<ShufflePartitionedData> ret = Lists.newArrayList();
        for (Map.Entry entry : req.getPartitionToBlocks().entrySet()) {
            ret.add(new ShufflePartitionedData(((Integer)entry.getKey()).intValue(), this.toPartitionedBlock((List)entry.getValue())));
        }
        return ret;
    }

    private ShufflePartitionedBlock[] toPartitionedBlock(List<ShuffleBlockInfo> blocks) {
        if (blocks == null || blocks.size() == 0) {
            return new ShufflePartitionedBlock[0];
        }
        ShufflePartitionedBlock[] ret = new ShufflePartitionedBlock[blocks.size()];
        int i = 0;
        for (ShuffleBlockInfo block : blocks) {
            ret[i] = new ShufflePartitionedBlock(block.getLength(), block.getUncompressLength(), block.getCrc(), block.getBlockId(), block.getTaskAttemptId(), block.getData());
            ++i;
        }
        return ret;
    }

    class ReleaseMemoryAndRecordReadTimeListener
    implements ChannelFutureListener {
        private final long readStartedTime;
        private final long readBufferSize;
        private final long dataSize;
        private final String requestInfo;
        private final RequestMessage request;
        private final TransportClient client;

        ReleaseMemoryAndRecordReadTimeListener(long readStartedTime, long readBufferSize, long dataSize, String requestInfo, RequestMessage request, TransportClient client) {
            this.readStartedTime = readStartedTime;
            this.readBufferSize = readBufferSize;
            this.dataSize = dataSize;
            this.requestInfo = requestInfo;
            this.request = request;
            this.client = client;
        }

        public void operationComplete(ChannelFuture future) {
            ShuffleServerNettyHandler.this.shuffleServer.getShuffleBufferManager().releaseReadMemory(this.readBufferSize);
            long readTime = System.currentTimeMillis() - this.readStartedTime;
            ShuffleServerMetrics.counterTotalReadTime.inc((double)readTime);
            ShuffleServerNettyHandler.this.shuffleServer.getNettyMetrics().recordProcessTime(this.request.getClass().getName(), readTime);
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                String errorMsg = "Error happened when executing " + this.request.getOperationType() + " for " + this.requestInfo + ", " + cause.getMessage();
                if (future.channel().isWritable()) {
                    GetLocalShuffleDataResponse errorResponse;
                    if (this.request instanceof GetLocalShuffleDataRequest) {
                        errorResponse = new GetLocalShuffleDataResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, (ManagedBuffer)new NettyManagedBuffer(Unpooled.EMPTY_BUFFER));
                    } else if (this.request instanceof GetLocalShuffleIndexRequest) {
                        errorResponse = new GetLocalShuffleIndexResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, Unpooled.EMPTY_BUFFER, 0L);
                    } else if (this.request instanceof GetMemoryShuffleDataRequest) {
                        errorResponse = new GetMemoryShuffleDataResponse(this.request.getRequestId(), StatusCode.INTERNAL_ERROR, errorMsg, Lists.newArrayList(), Unpooled.EMPTY_BUFFER);
                    } else {
                        LOG.error("Cannot handle request {}", (Object)this.request.type(), (Object)cause);
                        return;
                    }
                    this.client.getChannel().writeAndFlush((Object)errorResponse);
                }
                LOG.error("Failed to execute {} for {}. Took {} ms and could not retrieve {} bytes of data", new Object[]{this.request.getOperationType(), this.requestInfo, readTime, this.dataSize, cause});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully executed {} for {}. Took {} ms and retrieved {} bytes of data", new Object[]{this.request.getOperationType(), this.requestInfo, readTime, this.dataSize});
            }
        }
    }
}

